//=============================================================================
// VisuStella MZ - Party System
// VisuMZ_2_PartySystem.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_PartySystem = true;

var VisuMZ = VisuMZ || {};
VisuMZ.PartySystem = VisuMZ.PartySystem || {};
VisuMZ.PartySystem.version = 1.22;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 2] [Version 1.22] [PartySystem]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Party_System_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * RPG Maker MZ only gives game projects the ability to switch party members
 * within the main menu and nothing more. There's no inherent functionality to
 * lock party members, make party members required, and/or give players the
 * ability to switch party members mid-battle.
 *
 * This plugin will add in all of those functions as well as a dedicated scene
 * for switching party members. Party switching will allow party members to be
 * removed, swapped, and sorted. Through the usage of Plugin Commands, party
 * members can also be locked and/or required for party presence.
 *
 * Those using the VisuStella MZ Battle Core will also have access to features
 * in this plugin that aren't available otherwise. These features give players
 * the functionality to switch out the whole party lineup mid-battle and/or
 * individual party member switching.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Custom scene dedicated to party management.
 * * Change the maximum number of party members that can participate in battle.
 * * Plugin Commands to lock party members.
 * * Plugin Commands to make certain party members required.
 * * Added functionality with Battle Core to switch party members mid-battle.
 * * This comes in the form of changing either the whole party at once.
 * * Or switching individual members out one at a time.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 2 ------
 *
 * This plugin is a Tier 2 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 *
 * Main Menu Formation Command
 *
 * - This command is now changed to send the player to Scene_Party for the
 * player to have a dedicated scene for changing the party.
 *
 * ---
 *
 * Battle Members Array
 *
 * - Previously, the battle members are decided by which actors are lined up
 * first in the party roster. This has been changed to give players the freedom
 * to have a party size less than the maximum. This change is made by changing
 * the way the battle members are determined by using a new array. However, any
 * and all functions utilize the $gameParty.battleMembers() function will still
 * behave as normal.
 *
 * ---
 *
 * Formation Change OK Function
 *
 * - RPG Maker MZ did not do anything with the Game_Actor.isFormationChangeOk
 * function so this plugin overwrote it completely to allow for the new
 * lock and require features to work.
 *
 * ---
 *
 * ============================================================================
 * Extra Features
 * ============================================================================
 *
 * There are some extra features found if other VisuStella MZ plugins are found
 * present in the Plugin Manager list.
 *
 * ---
 *
 * VisuMZ_1_BattleCore
 *
 * - If the VisuStella MZ Battle Core plugin is present, players are able to 
 * access party switching functionality mid-battle at will. This can be in the
 * form of switching out the entire active party roster at once or individually
 * for each actor.
 *
 * - Switching Entire Rosters: This can be done by going into this plugin's
 * Plugin Parameters => General => Party Command Window => Add Party Command.
 * If the Party Command Window is accessible, the player will be able to see
 * the option between 'Auto Battle' and 'Options'.
 *
 * - Individual Member Switching: This requires going to VisuMZ_1_BattleCore's
 * Plugin Parameters => Actor Command Window => Battle Commands => Command List
 * and add in the "party" option. The "party" option can also be added to the
 * <Battle Commands> notetag.
 *
 * ---
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 *
 * ---
 * 
 * VisuMZ_2_BattleSystemOTB
 * 
 * With Battle System - OTB, the player cannot change entire parties at once
 * from the Party Command Window. The feature will be unaccessible while
 * Order Turn Battle is in play. However, the player can still change party
 * members through the Actor Command Window by having actors replace other
 * actors. Party changing is also available through battle events, Common
 * Events, and script calls.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Party Plugin Commands ===
 * 
 * ---
 *
 * Party: Call Party Scene
 * - Calls the party changing scene.
 *
 * ---
 *
 * Party: Change Max Battle Members
 * - Changes the number of max battle members possible.
 * - Cannot be use mid-battle.
 *
 *   Max Members:
 *   - Changes the number of max battle members possible.
 *   - Use 0 for the game's default number.
 *
 * ---
 *
 * Party: Lock/Unlock Member(s)
 * - Allows you to lock/unlock a party member.
 * - Locked actors cannot change their party position.
 *
 *   Actor ID(s):
 *   - Select which actor(s) to lock/unlock.
 *   - Locked actors cannot change their party position.
 *
 *   Lock?:
 *   - Lock the selected actor(s)?
 *
 * ---
 * 
 * Party: Move Actor(s) to Active
 * - Map Only.
 * - Moves an actor to the active party if there is room.
 * - The actor needs to have joined the party.
 * 
 *   Actor ID(s):
 *   - Select which actor(s) to move to the active party if there is room.
 * 
 * ---
 * 
 * Party: Move Actor(s) to Reserve
 * - Map Only.
 * - Moves an actor to the reserve party.
 * - Must be 1 actor left.
 * - The actor needs to have joined the party.
 * 
 *   Actor ID(s):
 *   - Select which actor(s) to move to the reserve party.
 * 
 * ---
 * 
 * Party: Move Party Index to Reserve
 * - Map only.
 * - Moves an actor in a specific party index to reserve.
 * - Must be 1 actor left.
 * 
 *   Index:
 *   - Type in which index to move.
 *   - Index values start at 0.
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * Party: Move Random Reserve to Active
 * - Map only.
 * - Moves a random actor from the reserve party to active.
 * - Must be enough space in active party.
 * 
 * ---
 *
 * Party: Require Member(s)
 * - Allows you to require/free a party member.
 * - Required actors must be in the party to exit the scene.
 *
 *   Actor ID(s):
 *   - Select which actor(s) to require/free.
 *   - Required actors must be in the party to exit the scene.
 *
 *   Require?:
 *   - Make the selected actor(s) required?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: General Settings
 * ============================================================================
 *
 * These Plugin Parameters control the overall behaviors pertaining to the
 * Party System added with this plugin. These behaviors range from the maximum
 * number of members that can participate in battle to the availability of the
 * party switching mechanics.
 *
 * ---
 *
 * General
 * 
 *   Max Battle Members:
 *   - Maximum number of battle members.
 *
 * ---
 *
 * Party Scene
 * 
 *   Add Remove Command:
 *   - Add the 'Remove' command to the party scene?
 * 
 *   Locked Member Icon:
 *   - Icon used for a locked party member.
 * 
 *   Required Member Icon:
 *   - Icon used for a required party member.
 *
 * ---
 *
 * Party Command Window
 * - These require VisuMZ_1_BattleCore!
 * 
 *   Add Party Command:
 *   - Add the 'Party' command to the Party Command Window?
 * 
 *   Command Cooldown:
 *   - Cooldown (in turns) for this command to be available again.
 *
 * ---
 *
 * Actor Command Window
 * - These require VisuMZ_1_BattleCore!
 * 
 *   Add Switch Command:
 *   - Add the 'Switch' command to the Actor Command Window?
 * 
 *   Command Cooldown:
 *   - Cooldown (in turns) for this command to be available again.
 * 
 *   Switch Out Animation?:
 *   - Show the sprites switching out when using individual party
 *     member switching?
 * 
 *   TPB: Immediate Action:
 *   - Allow actors to immediate act upon switching in for TPB battle systems?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Vocabulary Settings
 * ============================================================================
 *
 * These Plugin Parameters control the text that you see in-game related to the
 * Party System plugin.
 *
 * ---
 *
 * General
 * 
 *   Active Party:
 *   - Vocabulary used to represent the Active Party.
 * 
 *   Reserve Party:
 *   - Vocabulary used to represent the Reserve Party.
 * 
 *   Status:
 *   - Vocabulary used to represent the Status Window.
 * 
 *   Show Back Rectangles?:
 *   - Show back rectangles of darker colors to display information better?
 * 
 *     Back Rectangle Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors
 *       from the Window Skin.
 *
 * ---
 *
 * Party Scene > Windows
 * 
 *   Empty:
 *   - For the party and status windows when no actor is selected.
 * 
 *   Remove:
 *   - For the remove option.
 *
 * ---
 *
 * Party Scene > Button Assist
 * 
 *   Swap Positions:
 *   - Button assist text for the page up/down commands.
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Remove:
 *   - Button assist text for the removal command.
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Sort:
 *   - Button assist text for the sort command.
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Swap In:
 *   - Button assist text for swapping in actors.
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Swap Out:
 *   - Button assist text for swapping out actors.
 *   - Requires VisuMZ_0_CoreEngine!
 *
 * ---
 *
 * Battle Scene
 * 
 *   Party Command:
 *   - Command text for entering Party Scene.
 *   - Requires VisuMZ_1_BattleCore!
 * 
 *   Help: Formation:
 *   - Help text for Formation command.
 *   - Requires VisuMZ_1_BattleCore!
 * 
 *   Queue Message:
 *   - Message to say the Party Scene is queued.
 *   - Requires VisuMZ_1_BattleCore!
 * 
 *   Switch Command:
 *   - Command text for switching out members.
 *   - Requires VisuMZ_1_BattleCore!
 * 
 *   Help: Switch:
 *   - Help text for Switch command.
 *   - Requires VisuMZ_1_BattleCore!
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Background Settings
 * ============================================================================
 *
 * Background settings for Scene_Party.
 *
 * ---
 *
 * Background Settings
 * 
 *   Snapshop Opacity:
 *   - Snapshot opacity for the scene.
 * 
 *   Background 1:
 *   - Filename used for the bottom background image.
 *   - Leave empty if you don't wish to use one.
 * 
 *   Background 2:
 *   - Filename used for the upper background image.
 *   - Leave empty if you don't wish to use one.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Window Settings
 * ============================================================================
 *
 * If you don't like the locations of the windows in Scene_Party, change them
 * up with these Plugin Parameters, provided that you have an understanding of
 * JavaScript code.
 *
 * ---
 *
 * Active Party Label
 * Active Party Window
 * Reserve Party Label
 * Reserve Party Window
 * Status Label
 * Status Window
 * Battle Switch Window
 * 
 *   Background Type:
 *   - Select background type for this window.
 * 
 *   Columns:
 *   - Available only for the Reserve Party Window.
 *   - How many columns do you want there to be for the window?
 * 
 *   Actor Graphic:
 *   - Available only for Active Party Window and Reserve Party Window.
 *   - Choose how the actor graphics appear in the specific windows.
 *     - Face
 *     - Map Sprite
 *     - Sideview Battler (Requires VisuMZ_1_MainMenuCore)
 * 
 *     Map Sprite:
 *     Sideview Battler:
 * 
 *       Offset X:
 *       Offset Y:
 *       - If showing map sprites, offset the x or y coordinates.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.22: July 16, 2021
 * * Feature Update!
 * ** Added a fail safe that prevents on-battle start events from triggering
 *    when adding party members outside of battle under evented circumstances
 *    that function as a bridge between event and battle. Fix by Irina.
 * 
 * Version 1.21: July 9, 2021
 * * Bug Fixes!
 * ** When using TPB-based battle systems, adding actors to the main party
 *    would not enable them to move. This should be fixed. Fix made by Irina.
 * 
 * Version 1.20: July 2, 2021
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.19: June 18, 2021
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.18: April 16, 2021
 * * Documentation Update!
 * ** Fixed typo. Fix made by Arisu.
 * 
 * Version 1.17: March 26, 2021
 * * Documentation Update!
 * ** Added "VisuStella MZ Compatibility" section for detailed compatibility
 *    explanations with the VisuMZ_2_BattleSystemOTB plugin.
 * 
 * Version 1.16: March 19, 2021
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.15: March 5, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features
 * ** New Plugin Parameter added by Irina:
 * *** Plugin Parameters > Gneral > Battle Scene > Battle Party Icon
 * **** For some reason, we never had a setting that lets you change the party
 *      icon. Well, now there is!
 * 
 * Version 1.14: February 5, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Commands added by Arisu!
 * *** Party: Move Party Index to Reserve
 * **** Moves an actor in a specific party index to reserve.
 *      Map only. Must be 1 actor left. You may use code.
 * *** Party: Move Random Reserve to Active
 * **** Moves a random actor from the reserve party to active.
 *      Map only. Must be enough space in active party.
 * 
 * Version 1.13: January 29, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Commands added by Arisu!
 * *** Party: Move Actor(s) to Active
 * **** Map only. Moves an actor to the active party if there is room.
 * *** Party: Move Actor(s) to Reserve
 * **** Map only. Moves an actor to the reserve party.
 * 
 * Version 1.12: January 15, 2021
 * * Bug Fixes!
 * ** For battle testing, if the number of battle test members exceeds the
 *    maximum battle member slots, trim them until they match. Fix by Olivia.
 * 
 * Version 1.11: January 1, 2021
 * * Compatibility Update
 * ** Plugins should be more compatible with one another.
 * 
 * Version 1.10: December 25, 2020
 * * Compatibility Update
 * ** Plugins should be more compatible with one another.
 * 
 * Version 1.09: December 18, 2020
 * * Bug Fixes!
 * ** Removing party members in the active party by event command will now be
 *    properly removed from the party. Fix made by Yanfly.
 * 
 * Version 1.08: December 4, 2020
 * * Bug Fixes!
 * ** With TPB battle systems, after switching out party members, the battle
 *    system will no longer carry over any previous active battle members in
 *    the command window. Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * 
 * Version 1.07: November 22, 2020
 * * Bug Fixes!
 * ** With Active TPB, switching out a party member mid-action is no longer
 *    possible to prevent bugs. Intead, there party switching action will be
 *    queued and take effect after the action has been completed. Fix made by
 *    Yanfly.
 * * Compatibility Update!
 * ** Game_Party.swapOrder function now works with this plugin. However, keep
 *    in mind that due to how this party system plugin allows you have empty
 *    slots in the active battle party, this function will fill in the empty
 *    slots upon usage. Update made by Yanfly.
 *
 * Version 1.06: November 1, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * 
 * Version 1.05: October 25, 2020
 * * Bug Fixes!
 * ** Plugin Command "Party: Change Max Battle Members" now works again.
 *    Fix made by Arisu.
 *
 * Version 1.04: October 18, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * 
 * Version 1.03: October 11, 2020
 * * Bug Fixes!
 * ** Adding party members during battle through the party window command will
 *    no longer cause crashes after they input an action. Fix made by Yanfly.
 * 
 * Version 1.02: October 4, 2020
 * * Bug Fixes!
 * ** Adding party members during test play should now work again.
 *    Fix made by Irina.
 * ** Changing party members mid-battle through the actor command should now
 *    refresh the party followers afterwards. Fix made by Yanfly.
 * * New Features!
 * ** New Plugin Parameter added by Arisu!
 * *** General > Party Command Window > TPB: Immediate Action
 * **** Allow actors to immediate act upon switching in for TPB battle systems?
 * 
 * Version 1.01: September 27, 2020
 * * Bug Fixes!
 * ** When switching actors with states, buffs, and/or debuffs already applied,
 *    the state icons found in the status window will now switch over properly,
 *    too. Fix made by Arisu.
 *
 * Version 1.00: September 7, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command CallPartyScene
 * @text Party: Call Party Scene
 * @desc Calls the party changing scene.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ChangeMaxBattleMembers
 * @text Party: Change Max Battle Members
 * @desc Changes the number of max battle members possible.
 * Cannot be use mid-battle.
 *
 * @arg Value:eval
 * @text Max Members
 * @desc Changes the number of max battle members possible.
 * Use 0 for the game's default number.
 * @default 4
 *
 * @ --------------------------------------------------------------------------
 *
 * @command LockPartyMembers
 * @text Party: Lock/Unlock Member(s)
 * @desc Allows you to lock/unlock a party member.
 * Locked actors cannot change their party position.
 *
 * @arg Actors:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which actor(s) to lock/unlock.
 * Locked actors cannot change their party position.
 * @default ["1"]
 * 
 * @arg Lock:eval
 * @text Lock?
 * @type boolean
 * @on Lock
 * @off Unlock
 * @desc Lock the selected actor(s)?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MoveActorsToActive
 * @text Party: Move Actor(s) to Active
 * @desc Moves an actor to the active party if there is room.
 * Map only. The actor needs to have joined the party.
 *
 * @arg Actors:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which actor(s) to move to the active party if there is room.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MoveActorsToReserve
 * @text Party: Move Actor(s) to Reserve
 * @desc Moves an actor to the reserve party. Must be 1 actor left.
 * Map only. The actor needs to have joined the party.
 *
 * @arg Actors:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which actor(s) to move to the reserve party.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MovePartyIndexToReserve
 * @text Party: Move Party Index to Reserve
 * @desc Moves an actor in a specific party index to reserve.
 * Map only. Must be 1 actor left.
 *
 * @arg Index:eval
 * @text Party Index
 * @desc Type in which index to move. Index values start at 0.
 * You may use JavaScript code.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MoveRandomToActive
 * @text Party: Move Random Reserve to Active
 * @desc Moves a random actor from the reserve party to active.
 * Map only. Must be enough space in active party.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command RequirePartyMembers
 * @text Party: Require Member(s)
 * @desc Allows you to require/free a party member.
 * Required actors must be in the party to exit the scene.
 *
 * @arg Actors:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which actor(s) to require/free.
 * Required actors must be in the party to exit the scene.
 * @default ["1"]
 * 
 * @arg Require:eval
 * @text Require?
 * @type boolean
 * @on Require
 * @off Don't Require
 * @desc Make the selected actor(s) required?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param PartySystem
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param General:struct
 * @text General Settings
 * @type struct<General>
 * @desc General settings pertaining to Party-related mechanics.
 * @default {"General":"","MaxBattleMembers:num":"4","PartyScene":"","AddRemoveCmd:eval":"true","LockIcon:num":"195","RequireIcon:num":"87","DrawBackRect:eval":"true","BackRectColor:str":"19","PartyCmdWin":"","PartyCmdWinAddParty:eval":"false","PartyCmdCooldown:num":"1","tpbImmediateAction:eval":"true","ActorCmdWin":"","ActorCmdWinAddParty:eval":"true","ActorCmdCooldown:num":"1","SwitchOutAnimation:eval":"true"}
 *
 * @param Vocab:struct
 * @text Vocabulary Settings
 * @type struct<Vocab>
 * @desc These settings let you adjust the text displayed for this plugin.
 * @default {"General":"","ActiveParty:str":"Active Party","ReserveParty:str":"Reserve Party","Status:str":"Status","PartyScene":"","Windows":"","Empty:str":"- Empty -","Remove:str":"Remove","ButtonAssist":"","AssistSwapPosition:str":"Quick Swap","AssistRemove:str":"Remove","AssistSort:str":"Sort","AssistSwapIn:str":"Swap In","AssistSwapOut:str":"Swap Out","BattleScene":"","BattlePartyCmd:str":"Party","BattleHelpFormation:json":"\"Change up your party formation.\"","QueuePartyScene:str":"%1 Menu queued after action is complete.","BattleSwitchOut:str":"Switch","BattleHelpSwitch:json":"\"Switch out this party member with another.\""}
 *
 * @param BgSettings:struct
 * @text Background Settings
 * @type struct<BgSettings>
 * @desc Background settings for Scene_Party.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Window:struct
 * @text Window Settings
 * @type struct<Window>
 * @desc These settings let you control how the windows appear in Scene_Party.
 * @default {"ActivePartyLabel":"","ActivePartyLabelBgType:num":"0","ActivePartyLabelRect:func":"\"const wx = 0;\\nconst wy = this.mainAreaTop();\\nconst ww = Graphics.boxWidth;\\nconst wh = Window_Base.prototype.lineHeight();\\nreturn new Rectangle(wx, wy, ww, wh);\"","ActivePartyWindow":"","ActivePartyWindowBgType:num":"0","ActivePartyGraphic:str":"face","ActivePartyMapSprite":"","ActiveSpriteOffsetX:num":"0","ActiveSpriteOffsetY:num":"4","ActivePartySvBattler":"","ActiveBattlerOffsetX:num":"0","ActiveBattlerOffsetY:num":"4","ActivePartyWindowRect:func":"\"const wx = 0;\\nconst wy = this._activePartyLabel.y + this._activePartyLabel.height;\\nconst ww = Graphics.boxWidth;\\nconst wh = ImageManager.faceHeight + $gameSystem.windowPadding() * 2 + 2;\\nreturn new Rectangle(wx, wy, ww, wh);\"","ReservePartyLabel":"","ReservePartyLabelBgType:num":"0","ReservePartyLabelRect:func":"\"const ww = Math.max(240, Math.min(Graphics.boxWidth - 576, Math.round(Graphics.boxWidth / 2)));\\nconst wx = this.isRightInputMode() ? (Graphics.boxWidth - ww) : 0;\\nconst wy = this._activePartyWindow.y + this._activePartyWindow.height;\\nconst wh = Window_Base.prototype.lineHeight();\\nreturn new Rectangle(wx, wy, ww, wh);\"","ReservePartyWindow":"","ReservePartyWindowBgType:num":"0","ReserveItemThickness:num":"2","ReservePartyGraphic:str":"face","ReservePartyMapSprite":"","ReserveSpriteOffsetX:num":"24","ReserveSpriteOffsetY:num":"4","ReservePartySvBattler":"","ReserveBattlerOffsetX:num":"48","ReserveBattlerOffsetY:num":"4","ReservePartyWindowRect:func":"\"const ww = this._reservePartyLabel.width;\\nconst wx = this._reservePartyLabel.x;\\nconst wy = this._reservePartyLabel.y + this._reservePartyLabel.height;\\nconst wh = this.mainAreaHeight() - this._reservePartyLabel.height - this._activePartyWindow.height - this._activePartyLabel.height;\\nreturn new Rectangle(wx, wy, ww, wh);\"","StatusLabel":"","StatusLabelBgType:num":"0","StatusLabelRect:func":"\"const ww = Graphics.boxWidth - this._reservePartyLabel.width;\\nconst wx = this.isRightInputMode() ? 0 : (Graphics.boxWidth - ww);\\nconst wy = this._activePartyWindow.y + this._activePartyWindow.height;\\nconst wh = Window_Base.prototype.lineHeight();\\nreturn new Rectangle(wx, wy, ww, wh);\"","StatusWindow":"","StatusWindowBgType:num":"0","StatusWindowDraw:func":"\"// Draw Empty\\nif (!this._actor) {\\n    this.drawItemDarkRect(0, 0, this.innerWidth, this.innerHeight);\\n    const y = Math.round((this.innerHeight - this.lineHeight()) / 2);\\n    this.changeTextColor(ColorManager.systemColor());\\n    this.drawText(TextManager.emptyPartyMember, 0, y, this.innerWidth, 'center');\\n    return;\\n}\\n\\n// Draw Face and Simple Status\\nthis.drawActorFace(this._actor, 1, 0, ImageManager.faceWidth, ImageManager.faceHeight);\\nthis.drawActorSimpleStatus(this._actor, ImageManager.faceWidth + 36, 0);\\n\\n// Declare Constants\\nconst lineHeight = this.lineHeight();\\nconst params = this.actorParams();\\nconst paramWidth = Math.round(this.innerWidth / 2);\\nconst paramHeight = Math.ceil(params.length / 2) * lineHeight;\\nconst baseX = 0;\\nlet x = 0;\\nlet y = ImageManager.faceHeight + lineHeight / 2;\\n\\n// Draw Parameters\\nfor (const param of params) {\\n    this.drawItemDarkRect(x, y, paramWidth, lineHeight);\\n    this.drawParamName(param, x, y, paramWidth);\\n    this.drawParamValue(param, x, y, paramWidth);\\n\\n    if (x === baseX) {\\n        x += paramWidth;\\n    } else {\\n        x = baseX;\\n        y += lineHeight;\\n    }\\n}\"","StatusWindowRect:func":"\"const ww = this._statusPartyLabel.width;\\nconst wx = this.isRightInputMode() ? 0 : (Graphics.boxWidth - ww);\\nconst wy = this._reservePartyWindow.y;\\nconst wh = this._reservePartyWindow.height;\\nreturn new Rectangle(wx, wy, ww, wh);\"","BattleSwitchWindow":"","BattleSwitchWindowBgType:num":"0","BattleSwitchWindowRect:func":"\"const padding = $gameSystem.windowPadding() * 2;\\nlet ww = 516 + padding;\\nlet wh = Window_PartyBattleSwitch.prototype.itemHeight() * 4 + padding;\\nlet wx = Math.round(Graphics.boxWidth - ww) / 2;\\nlet wy = Math.round(Graphics.boxHeight - wh - this._statusWindow.height) / 2;\\nwy = wy.clamp(0, Graphics.boxHeight - wh - this._statusWindow.height);\\nreturn new Rectangle(wx, wy, ww, wh);\""}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * General Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~General:
 *
 * @param General
 *
 * @param MaxBattleMembers:num
 * @text Max Battle Members
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of battle members.
 * @default 4
 *
 * @param BattleScene
 * @text Battle Scene
 *
 * @param BattlePartyIcon:num
 * @text Battle Party Icon
 * @parent BattleScene
 * @desc Icon used for changing party members.
 * @default 75
 *
 * @param PartyScene
 * @text Party Scene
 *
 * @param AddRemoveCmd:eval
 * @text Add Remove Command
 * @parent PartyScene
 * @type boolean
 * @on Add Command
 * @off Don't Add
 * @desc Add the 'Remove' command to the party scene?
 * @default true
 *
 * @param LockIcon:num
 * @text Locked Member Icon
 * @parent PartyScene
 * @desc Icon used for a locked party member.
 * @default 195
 *
 * @param RequireIcon:num
 * @text Required Member Icon
 * @parent PartyScene
 * @desc Icon used for a required party member.
 * @default 87
 *
 * @param DrawBackRect:eval
 * @text Show Back Rectangles?
 * @parent PartyScene
 * @type boolean
 * @on Draw
 * @off Don't Draw
 * @desc Show back rectangles of darker colors to display information better?
 * @default true
 *
 * @param BackRectColor:str
 * @text Back Rectangle Color
 * @parent DrawBackRect:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 19
 *
 * @param PartyCmdWin
 * @text Party Command Window
 *
 * @param PartyCmdWinAddParty:eval
 * @text Add Party Command
 * @parent PartyCmdWin
 * @type boolean
 * @on Add Command
 * @off Don't Add
 * @desc Add the 'Party' command to the Party Command Window?
 * @default false
 *
 * @param PartyCmdCooldown:num
 * @text Command Cooldown
 * @parent PartyCmdWin
 * @desc Cooldown (in turns) for this command to be available again.
 * @default 1
 *
 * @param ActorCmdWin
 * @text Actor Command Window
 *
 * @param ActorCmdWinAddParty:eval
 * @text Add Switch Command
 * @parent ActorCmdWin
 * @type boolean
 * @on Add Command
 * @off Don't Add
 * @desc Add the 'Switch' command to the Actor Command Window?
 * @default true
 *
 * @param ActorCmdCooldown:num
 * @text Command Cooldown
 * @parent ActorCmdWin
 * @desc Cooldown (in turns) for this command to be available again.
 * @default 1
 *
 * @param SwitchOutAnimation:eval
 * @text Switch Out Animation?
 * @parent ActorCmdWin
 * @type boolean
 * @on Show
 * @off Don't
 * @desc Show the sprites switching out when using individual party member switching?
 * @default true
 *
 * @param tpbImmediateAction:eval
 * @text TPB: Immediate Action
 * @parent ActorCmdWin
 * @type boolean
 * @on Immediate Action
 * @off Empty Gauge
 * @desc Allow actors to immediate act upon switching in for TPB battle systems?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Vocabulary Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Vocab:
 *
 * @param General
 *
 * @param ActiveParty:str
 * @text Active Party
 * @parent General
 * @desc Vocabulary used to represent the Active Party.
 * @default Active Party
 *
 * @param ReserveParty:str
 * @text Reserve Party
 * @parent General
 * @desc Vocabulary used to represent the Reserve Party.
 * @default Reserve Party
 *
 * @param Status:str
 * @text Status
 * @parent General
 * @desc Vocabulary used to represent the Status Window.
 * @default Status
 *
 * @param PartyScene
 * @text Party Scene
 *
 * @param Windows
 * @parent PartyScene
 *
 * @param Empty:str
 * @text Empty
 * @parent Windows
 * @desc For the party and status windows when no actor is selected.
 * @default - Empty -
 *
 * @param Remove:str
 * @text Remove
 * @parent Windows
 * @desc For the remove option.
 * @default Remove
 *
 * @param ButtonAssist
 * @text Button Assist
 * @parent PartyScene
 *
 * @param AssistSwapPosition:str
 * @text Swap Positions
 * @parent ButtonAssist
 * @desc Button assist text for the page up/down commands.
 * Requires VisuMZ_0_CoreEngine!
 * @default Quick Swap
 *
 * @param AssistRemove:str
 * @text Remove
 * @parent ButtonAssist
 * @desc Button assist text for the removal command.
 * Requires VisuMZ_0_CoreEngine!
 * @default Remove
 *
 * @param AssistSort:str
 * @text Sort
 * @parent ButtonAssist
 * @desc Button assist text for the sort command.
 * Requires VisuMZ_0_CoreEngine!
 * @default Sort
 *
 * @param AssistSwapIn:str
 * @text Swap In
 * @parent ButtonAssist
 * @desc Button assist text for swapping in actors.
 * Requires VisuMZ_0_CoreEngine!
 * @default Swap In
 *
 * @param AssistSwapOut:str
 * @text Swap Out
 * @parent ButtonAssist
 * @desc Button assist text for swapping out actors.
 * Requires VisuMZ_0_CoreEngine!
 * @default Swap Out
 *
 * @param BattleScene
 * @text Battle Scene
 *
 * @param BattlePartyCmd:str
 * @text Party Command
 * @parent BattleScene
 * @desc Command text for entering Party Scene.
 * Requires VisuMZ_1_BattleCore!
 * @default Party
 *
 * @param BattleHelpFormation:json
 * @text Help: Formation
 * @parent BattlePartyCmd:str
 * @type note
 * @desc Help text for Formation command.
 * Requires VisuMZ_1_BattleCore!
 * @default "Change up your party formation."
 *
 * @param QueuePartyScene:str
 * @text Queue Message
 * @parent BattlePartyCmd:str
 * @desc Message to say the Party Scene is queued.
 * Requires VisuMZ_1_BattleCore!
 * @default %1 Menu queued after action is complete.
 *
 * @param BattleSwitchOut:str
 * @text Switch Command
 * @parent BattleScene
 * @desc Command text for switching out members.
 * Requires VisuMZ_1_BattleCore!
 * @default Switch
 *
 * @param BattleHelpSwitch:json
 * @text Help: Switch
 * @parent BattleSwitchOut:str
 * @type note
 * @desc Help text for Switch command.
 * Requires VisuMZ_1_BattleCore!
 * @default "Switch out this party member with another."
 *
 */
/* ----------------------------------------------------------------------------
 * Background Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BgSettings:
 *
 * @param SnapshotOpacity:num
 * @text Snapshop Opacity
 * @type number
 * @min 0
 * @max 255
 * @desc Snapshot opacity for the scene.
 * @default 192
 *
 * @param BgFilename1:str
 * @text Background 1
 * @type file
 * @dir img/titles1/
 * @desc Filename used for the bottom background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 * @param BgFilename2:str
 * @text Background 2
 * @type file
 * @dir img/titles2/
 * @desc Filename used for the upper background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 */
/* ----------------------------------------------------------------------------
 * Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Window:
 *
 * @param ActivePartyLabel
 * @text Active Party Label
 *
 * @param ActivePartyLabelBgType:num
 * @text Background Type
 * @parent ActivePartyLabel
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ActivePartyLabelRect:func
 * @text JS: X, Y, W, H
 * @parent ActivePartyLabel
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const wx = 0;\nconst wy = this.mainAreaTop();\nconst ww = Graphics.boxWidth;\nconst wh = Window_Base.prototype.lineHeight();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param ActivePartyWindow
 * @text Active Party Window
 *
 * @param ActivePartyWindowBgType:num
 * @text Background Type
 * @parent ActivePartyWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ActivePartyGraphic:str
 * @text Actor Graphic
 * @parent ActivePartyWindow
 * @type select
 * @option None
 * @value none
 * @option Face
 * @value face
 * @option Map Sprite
 * @value sprite
 * @option Sideview Battler (Requires VisuMZ_1_MainMenuCore)
 * @value svbattler
 * @desc Choose how the actor graphics appear in the active party menu.
 * @default face
 *
 * @param ActivePartyMapSprite
 * @text Map Sprite
 * @parent ActivePartyGraphic:str
 *
 * @param ActiveSpriteOffsetX:num
 * @text Offset X
 * @parent ActivePartyMapSprite
 * @desc If showing map sprites, offset the x coordinate here from center.
 * @default 0
 *
 * @param ActiveSpriteOffsetY:num
 * @text Offset Y
 * @parent ActivePartyMapSprite
 * @desc If showing map sprites, offset the y coordinate here from bottom.
 * @default 4
 *
 * @param ActivePartySvBattler
 * @text Sideview Battler
 * @parent ActivePartyGraphic:str
 *
 * @param ActiveBattlerOffsetX:num
 * @text Offset X
 * @parent ActivePartySvBattler
 * @desc If showing sideview battlers, offset the x coordinate here from center.
 * @default 0
 *
 * @param ActiveBattlerOffsetY:num
 * @text Offset Y
 * @parent ActivePartySvBattler
 * @desc If showing sideview battlers, offset the y coordinate here from bottom.
 * @default 4
 *
 * @param ActivePartyWindowRect:func
 * @text JS: X, Y, W, H
 * @parent ActivePartyWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const wx = 0;\nconst wy = this._activePartyLabel.y + this._activePartyLabel.height;\nconst ww = Graphics.boxWidth;\nconst wh = ImageManager.faceHeight + $gameSystem.windowPadding() * 2 + 2;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param ReservePartyLabel
 * @text Reserve Party Label
 *
 * @param ReservePartyLabelBgType:num
 * @text Background Type
 * @parent ReservePartyLabel
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ReservePartyLabelRect:func
 * @text JS: X, Y, W, H
 * @parent ReservePartyLabel
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.max(240, Math.min(Graphics.boxWidth - 576, Math.round(Graphics.boxWidth / 2)));\nconst wx = this.isRightInputMode() ? (Graphics.boxWidth - ww) : 0;\nconst wy = this._activePartyWindow.y + this._activePartyWindow.height;\nconst wh = Window_Base.prototype.lineHeight();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param ReservePartyWindow
 * @text Reserve Party Window
 *
 * @param ReservePartyWindowBgType:num
 * @text Background Type
 * @parent ReservePartyWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ReserveCol:num
 * @text Columns
 * @parent ReservePartyWindow
 * @type number
 * @min 1
 * @desc How many columns do you want there to be for the window?
 * @default 1
 *
 * @param ReserveItemThickness:num
 * @text Row Thickness
 * @parent ReservePartyWindow
 * @type number
 * @min 1
 * @desc How many rows thick do you want selectable items to be?
 * @default 2
 *
 * @param ReservePartyGraphic:str
 * @text Actor Graphic
 * @parent ReservePartyWindow
 * @type select
 * @option None
 * @value none
 * @option Face
 * @value face
 * @option Map Sprite
 * @value sprite
 * @option Sideview Battler (Requires VisuMZ_1_MainMenuCore)
 * @value svbattler
 * @desc Choose how the actor graphics appear in the reserve party menu.
 * @default face
 *
 * @param ReservePartyMapSprite
 * @text Map Sprite
 * @parent ReservePartyGraphic:str
 *
 * @param ReserveSpriteOffsetX:num
 * @text Offset X
 * @parent ReservePartyMapSprite
 * @desc If showing map sprites, offset the x coordinate here from left.
 * @default 24
 *
 * @param ReserveSpriteOffsetY:num
 * @text Offset Y
 * @parent ReservePartyMapSprite
 * @desc If showing map sprites, offset the y coordinate here from bottom.
 * @default 4
 *
 * @param ReservePartySvBattler
 * @text Sideview Battler
 * @parent ReservePartyGraphic:str
 *
 * @param ReserveBattlerOffsetX:num
 * @text Offset X
 * @parent ReservePartySvBattler
 * @desc If showing sideview battlers, offset the x coordinate here from left.
 * @default 48
 *
 * @param ReserveBattlerOffsetY:num
 * @text Offset Y
 * @parent ReservePartySvBattler
 * @desc If showing sideview battlers, offset the y coordinate here from bottom.
 * @default 4
 *
 * @param ReservePartyWindowRect:func
 * @text JS: X, Y, W, H
 * @parent ReservePartyWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = this._reservePartyLabel.width;\nconst wx = this._reservePartyLabel.x;\nconst wy = this._reservePartyLabel.y + this._reservePartyLabel.height;\nconst wh = this.mainAreaHeight() - this._reservePartyLabel.height - this._activePartyWindow.height - this._activePartyLabel.height;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StatusLabel
 * @text Status Label
 *
 * @param StatusLabelBgType:num
 * @text Background Type
 * @parent StatusLabel
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusLabelRect:func
 * @text JS: X, Y, W, H
 * @parent StatusLabel
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Graphics.boxWidth - this._reservePartyLabel.width;\nconst wx = this.isRightInputMode() ? 0 : (Graphics.boxWidth - ww);\nconst wy = this._activePartyWindow.y + this._activePartyWindow.height;\nconst wh = Window_Base.prototype.lineHeight();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StatusWindow
 * @text Status Window
 *
 * @param StatusWindowBgType:num
 * @text Background Type
 * @parent StatusWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusWindowDraw:func
 * @text JS: Draw Data
 * @parent StatusWindow
 * @type note
 * @desc Code used to draw the display data in the Status Window.
 * @default "// Draw Empty\nif (!this._actor) {\n    this.drawItemDarkRect(0, 0, this.innerWidth, this.innerHeight);\n    const y = Math.round((this.innerHeight - this.lineHeight()) / 2);\n    this.changeTextColor(ColorManager.systemColor());\n    this.drawText(TextManager.emptyPartyMember, 0, y, this.innerWidth, 'center');\n    return;\n}\n\n// Draw Face and Simple Status\nthis.drawActorFace(this._actor, 1, 0, ImageManager.faceWidth, ImageManager.faceHeight);\nthis.drawActorSimpleStatus(this._actor, ImageManager.faceWidth + 36, 0);\n\n// Declare Constants\nconst lineHeight = this.lineHeight();\nconst params = this.actorParams();\nconst paramWidth = Math.round(this.innerWidth / 2);\nconst paramHeight = Math.ceil(params.length / 2) * lineHeight;\nconst baseX = 0;\nlet x = 0;\nlet y = ImageManager.faceHeight + lineHeight / 2;\n\n// Draw Parameters\nfor (const param of params) {\n    this.drawItemDarkRect(x, y, paramWidth, lineHeight);\n    this.drawParamName(param, x, y, paramWidth);\n    this.drawParamValue(param, x, y, paramWidth);\n\n    if (x === baseX) {\n        x += paramWidth;\n    } else {\n        x = baseX;\n        y += lineHeight;\n    }\n}"
 *
 * @param StatusWindowRect:func
 * @text JS: X, Y, W, H
 * @parent StatusWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = this._statusPartyLabel.width;\nconst wx = this.isRightInputMode() ? 0 : (Graphics.boxWidth - ww);\nconst wy = this._reservePartyWindow.y;\nconst wh = this._reservePartyWindow.height;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param BattleSwitchWindow
 * @text Battle Switch Window
 *
 * @param BattleSwitchWindowBgType:num
 * @text Background Type
 * @parent BattleSwitchWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param BattleSwitchWindowRect:func
 * @text JS: X, Y, W, H
 * @parent BattleSwitchWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * Does not apply to Border Battle Layout style.
 * @default "const padding = $gameSystem.windowPadding() * 2;\nlet ww = 516 + padding;\nlet wh = Window_PartyBattleSwitch.prototype.itemHeight() * 4 + padding;\nlet wx = Math.round(Graphics.boxWidth - ww) / 2;\nlet wy = Math.round(Graphics.boxHeight - wh - this._statusWindow.height) / 2;\nwy = wy.clamp(0, Graphics.boxHeight - wh - this._statusWindow.height);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
//=============================================================================

const _0x2b81=['name','increaseTurn','VisuMZ_0_CoreEngine','_inputting','systemColor','updateBattleProcess','PeQCW','_battleSystemIncompatibilityError','reserveTransfer','updateBattlePartySwitchCooldown','ActivePartyLabelRect','_bypassAutoSavePartySystem','remove','popScene','_backSprite1','createActivePartyWindow','isSceneMap','isCTB','deactivate','processPartySwitchMember','startSwitchInAnimation','formation','members','isAppeared','CGeqy','MoveActorsToReserve','assistRemovePartyMember','processShiftSortShortcut','Sprite_Actor_update','drawItemImageSprite','fillRect','initBattleMembers','toUpperCase','isAutosaveEnabled','_otb_actionBattlersNext','paintOpacity','PartyCmdCooldown','removePartyMember','diUvn','dpVCF','svbattler','exit','setBackgroundType','_partySystemSwitchOut','EVAL','border','cursorVisible','height','createActivePartyLabel','changeTextColor','processCursorMove','description','onBattlePartySwitch','Game_Troop_increaseTurn','actor%1-stateIcon','battleMembers','update','LockIcon','splice','toLowerCase','call','_helpWindow','createPartyCommandWindowBattleCore','Vocab','maxBattleMembers','helpAreaHeight','battlePartySwitchCmd','SceneManager_isNextSceneBattleTransitionable','ARRAYEVAL','faceName','fvDXm','isEnabled','getBackgroundOpacity','addActorToBattleMembers','MaxBattleMembers','maxCols','BattlePartyCmd','AssistSwapPosition','callFormation','XyrPH','DrawBackRect','getPartySystemBackColor','ReserveBattlerOffsetX','addWindow','HtCNC','DhRvP','reserveMembers','findSymbol','commandPartyMemberSwitch','Window','random','bitmap','StatusWindowBgType','activePartyLabelRect','callPartyMemberSwitch','visible','STR','Scene_Base_isAutosaveEnabled','Require','canSwitchPartyInBattle','isPreviousScene','preparePartySwitchMember','drawIcon','setStatusWindow','createReservePartyLabel','refreshAllWindows','BattleHelpFormation','oDzbn','Settings','isSceneParty','Game_Party_swapOrder','ActorCmdCooldown','_logWindow','TZnNp','Remove','isShiftRemoveShortcutEnabled','create','_actorGraphic','needsPageButtons','loadSvActor','QueuePartyScene','njWOf','deselect','battlePartySwitchCooldown','reserveParty','isOkEnabled','ARRAYNUM','createBackground','drawItemImageSvActor','initEquips','IAsVs','createReservePartyWindow','itemPadding','BattleHelpSwitch','setupStartingMembers','isCancelEnabled','ReservePartyWindowBgType','removeActorFromBattleMembers','center','lockPartyMemberIcon','SnapshotOpacity','ReservePartyGraphic','Nucfe','ReservePartyLabelBgType','_backSprite2','650128llIiNZ','inBattle','hasBattleSystemIncompatibilities','VisuMZ_2_BattleSystemETB','statusWindowRect','bind','drawParamText','CFlZm','battlePartyChangeIcon','allMembers','addNonBattleTestMembers','MovePartyIndexToReserve','onPartySwitchCancel','uiMenuStyle','BackRectColor','jmiZY','_pageupButton','SceneManager_isPreviousSceneBattleTransitionable','_reservePartyLabel','Game_Unit_inBattle','_actorCommandWindow','ensureCursorVisible','444014LyLFqC','STRUCT','currentActor','QcOsf','OLhKY','checkInitBattleMembers','AssistSwapIn','ARRAYFUNC','smoothSelect','krUWG','2956XVMnMu','ARRAYSTRUCT','clear','isFTB','ActivePartyWindowBgType','ReserveCol','textColor','_partyCommandWindow','contents','drawParamValue','MoveRandomToActive','updatePartySwitch','log','removeActionBattlersOTB','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','isShowPartySwitchOutAnimation','cQuZl','regenerateAll','close','RMECu','partySwitchWindowRect','_partyLocked','activate','innerWidth','characterName','parameters','setup','startMove','removeActor','isActiveTpb','text','faceWidth','isAlive','drawActorPartyIconsVert','constructor','283iXxEVQ','getColor','15YUCYYU','clearPartyBattleCommandCooldown','_statusWindow','refreshOG','initPartySystem','Empty','_actors','getInputButtonString','removePartyCommand','anyRequiredPartyMembersInReserve','battlePartyChangeCmd','sortActionOrdersBTB','width','addText','createStatusWindow','GauUZ','sprite','BattleManager_setup','\x5cI[%1]%2','swapOrderPartySystemPlugin','QmLln','isImmediateTpb','RequireIcon','right','teamBasedFirstAvailableMember','StatusWindowDraw','faceHeight','addActor','_currentActor','paramValueByName','Scene_Battle_isAnyInputWindowActive','trim','itemLineRect','actorId','sortActors','nameStartPosition','isBTB','SwitchOutAnimation','loadCharacter','playEquip','testBattlers','playOkSound','refresh','JSON','Game_Party_removeActor','hNNeS','currentSymbol','min','drawRemoveCommand','VisuMZ_2_BattleSystemPTB','rawBattleMembers','isRequiredInParty','select','cursorUp','statusLabelRect','statusParty','Game_Party_addActor','_activePartyLabel','tlJkL','dimColor1','_statusPartyWindow','drawActorCharacter','ChangeMaxBattleMembers','onReserveCancel','centerSprite','open','VisuMZ_2_BattleSystemCTB','pop','version','FxqLQ','skwOM','openness','resetFontSettings','defaultMaxBattleMembers','Game_Battler_regenerateAll','drawItem','postPartySwitchMenuTurnBased','MCkxy','drawActorClass','drawSvActor','cursorDown','innerHeight','ActiveBattlerOffsetX','CallPartyScene','reservePartyWindowRect','BattleSwitchOut','BgFilename2','YfySy','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','push','_callSceneParty','Value','indexOf','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','ceil','initialize','commandFormation','421039fxgtKQ','ConvertParams','commandStyle','registerCommand','AssistSwapOut','isSceneBattle','isPTB','onReserveOk','isFormationCommandEnabled','map','activeParty','_activePartyWindow','Lock','Game_Battler_onBattleStart','filter','iconWidth','cursorPageup','onActiveOk','addRemoveCommand','length','KAztC','addPartyCommand','initMaxBattleMembers','concat','_partySystemBattleCommandCooldown','param','_spriteset','BattleSwitchWindowBgType','ReserveParty','addCustomCommands','reselect','XZMBb','partySwitchWindowRectBorder','MBCgK','_partyMemberSwitchWindow','processDrawItem','Window_ActorCommand_updateHelp','ActiveBattlerOffsetY','ARRAYSTR','addActorToBattleMembersAtIndex','partyChangeRefresh','setBattlePartySwitchCooldown','_scene','iconHeight','dumeg','mapId','isTpb','_lastIndex','battlePartyChangeCmdHelp','prototype','shift','equips','clearPartySwitchCommandCooldown','_clickHandler','ActivePartyWindowRect','BgFilename1','fCIGd','gradientFillRect','face','includes','setBattler','isNextScene','pkoAD','makeActionOrders','lineHeight','ActiveSpriteOffsetX','buttonAssistKey3','setupBattleTestMembers','onBattleStart','getParamValue','oyfNH','buttonAssistText3','AddRemoveCmd','isTimeActive','addLoadListener','Actors','drawActorFace','buttonAssistText4','CGKbX','VisuMZ_1_MainMenuCore','xIXIG','parse','isPreviousSceneBattleTransitionable','match','gNWNF','clearBypassAutoSave','isFormationCommandAdded','_partyRequired','isPartyCommandAdded','requestRefresh','ActiveSpriteOffsetY','CoreEngine','AssistSort','tYCnp','updateTurnOrderSTB','level','setPartyRequirement','Game_Party_setupBattleTest','_actionBattlers','drawActorPartyIcons','isCurrentItemEnabled','isPartyCommandEnabled','792351gvLBPl','stepForward','isPlaytest','FUNC','cursorPagedown','assistSwapPositions','StatusLabelBgType','ReserveSpriteOffsetX','createStatusLabel','tpbImmediateAction','QaVRY','battler','switchStateIconActor','_statusPartyLabel','hpColor','kprXj','_windowLayer','processCancel','checkShiftSortShortcut','return\x200','eiQbY','isFormationEnabled','IGDGL','battleLayoutStyle','_actor','PartyCmdWinAddParty','LockPartyMembers','swapOrder','setText','createPartySwitchWindow','isShiftShortcutEnabled','isFormationChangeOk','Param','_partySwitchDuration','changePaintOpacity','_subject','requiredPartyMemberIcon','VisuMZ_2_BattleSystemFTB','eHQhy','VisuMZ_2_BattleSystemOTB','VNMWN','ActivePartyGraphic','Window_PartyCommand_updateHelp','BattleSwitchWindowRect','quickSwap','loadTitle1','round','_debug','selectActor','NUM','BgSettings','Status','adjustSprite','nqGEG','otbReturnBattlerToTurnOrders','General','index','emptyPartyMember','setupBattleTest','Scene_Battle_createActorCommandWindow','uiInputPosition','callUpdateHelp','isQueueFormationMenu','assistSwapOutPartyMember','drawParamName','setActor','ReservePartyLabelRect','actorParams','checkShiftRemoveShortcut','maxItems','setHandler','activePartyWindowRect','cancel','createActorCommandWindow','isActor','itemRectWithPadding','isRightInputMode','drawItemStatus','_list','max','Game_Actor_setup','itemRect','isOTB','format','_reservePartyWindow','reservePartyLabelRect','drawDarkRect','skillItemWindowRectBorderStyle','applyBattlePartySwitchCooldown','drawItemDarkRect','itemHeight','active','_battleMembers','_partySwitchBattleCommandCooldown','processOk','_callPartyMemberSwitch','VisuMZ_2_BattleSystemSTB','loadPartyImages','GWXMr','MoveActorsToActive','ReserveSpriteOffsetY','KHZlj','_tpbState','Scene_Battle_createPartyCommandWindowBattleCore','265993QDtNDS','ActorCmdWinAddParty','loadFace','followers','_battleMaxSize','postPartySwitchMenuTpb','placeBasicGauges','ActiveTpbFormationMessage','changeMaxBattleMembers','StatusLabelRect','Scene_Battle_isTimeActive','isTriggered','WMjYq','rearrangePartyActors','Scene_Battle_createAllWindows','terminate','44617AsexcC','snapForBackground','PartySystem','drawActorPartyIconsHorz','partySwitchWindowRectStandard','_rowThickness','loadTitle2','createCustomBackgroundImages','drawItemImage','sFggd','actor','sQXuU','fFbNk','drawText','ActivePartyLabelBgType','makeActions','createAllWindows','processShiftRemoveShortcut','recoverAll','drawItemEmpty','createPageButtons','onPartySwitchOk','isSTB','drawItemImageFace','updateHelp','isETB','_partySwitchTargetActor','Game_Party_initialize','setPartyLock','addChild','battlerName','WARNING:\x20Party\x20Change\x20command\x20is\x20unavailable\x20for\x20Window_PartyCommand\x20for\x20this\x20Battle\x20System','playCursorSound','addCommand','VisuMZ_1_BattleCore','yCgAs','startSwitchOutAnimation'];const _0x43c6f3=_0x2837;(function(_0x123a50,_0x4d7bc0){const _0x387994=_0x2837;while(!![]){try{const _0x4f691b=parseInt(_0x387994(0x2f0))+parseInt(_0x387994(0x28a))+-parseInt(_0x387994(0x204))*parseInt(_0x387994(0x227))+-parseInt(_0x387994(0x358))+parseInt(_0x387994(0x1fa))+-parseInt(_0x387994(0x229))*-parseInt(_0x387994(0x368))+-parseInt(_0x387994(0x1e4));if(_0x4f691b===_0x4d7bc0)break;else _0x123a50['push'](_0x123a50['shift']());}catch(_0x2c5a28){_0x123a50['push'](_0x123a50['shift']());}}}(_0x2b81,0x8c226));function _0x2837(_0x774676,_0xd52a88){return _0x2837=function(_0x2b815d,_0x2837f3){_0x2b815d=_0x2b815d-0x1e4;let _0xbe64d6=_0x2b81[_0x2b815d];return _0xbe64d6;},_0x2837(_0x774676,_0xd52a88);}var label=_0x43c6f3(0x36a),tier=tier||0x0,dependencies=[],pluginData=$plugins['filter'](function(_0x4e01b4){const _0x1b5348=_0x43c6f3;return _0x4e01b4['status']&&_0x4e01b4[_0x1b5348(0x3c0)][_0x1b5348(0x2c5)]('['+label+']');})[0x0];VisuMZ[label][_0x43c6f3(0x3f9)]=VisuMZ[label][_0x43c6f3(0x3f9)]||{},VisuMZ['ConvertParams']=function(_0x43c491,_0x383916){const _0x59aa26=_0x43c6f3;for(const _0x42527f in _0x383916){if(_0x42527f[_0x59aa26(0x2dd)](/(.*):(.*)/i)){const _0x4ab606=String(RegExp['$1']),_0x5dc47d=String(RegExp['$2'])[_0x59aa26(0x3ad)]()[_0x59aa26(0x248)]();let _0x189fde,_0x1f4809,_0x19b151;switch(_0x5dc47d){case _0x59aa26(0x321):_0x189fde=_0x383916[_0x42527f]!==''?Number(_0x383916[_0x42527f]):0x0;break;case _0x59aa26(0x40b):_0x1f4809=_0x383916[_0x42527f]!==''?JSON['parse'](_0x383916[_0x42527f]):[],_0x189fde=_0x1f4809[_0x59aa26(0x293)](_0x30c411=>Number(_0x30c411));break;case _0x59aa26(0x3b9):_0x189fde=_0x383916[_0x42527f]!==''?eval(_0x383916[_0x42527f]):null;break;case _0x59aa26(0x3d1):_0x1f4809=_0x383916[_0x42527f]!==''?JSON[_0x59aa26(0x2db)](_0x383916[_0x42527f]):[],_0x189fde=_0x1f4809[_0x59aa26(0x293)](_0xb02196=>eval(_0xb02196));break;case _0x59aa26(0x254):_0x189fde=_0x383916[_0x42527f]!==''?JSON[_0x59aa26(0x2db)](_0x383916[_0x42527f]):'';break;case'ARRAYJSON':_0x1f4809=_0x383916[_0x42527f]!==''?JSON[_0x59aa26(0x2db)](_0x383916[_0x42527f]):[],_0x189fde=_0x1f4809['map'](_0x2674ee=>JSON[_0x59aa26(0x2db)](_0x2674ee));break;case _0x59aa26(0x2f3):_0x189fde=_0x383916[_0x42527f]!==''?new Function(JSON['parse'](_0x383916[_0x42527f])):new Function(_0x59aa26(0x303));break;case _0x59aa26(0x201):_0x1f4809=_0x383916[_0x42527f]!==''?JSON['parse'](_0x383916[_0x42527f]):[],_0x189fde=_0x1f4809[_0x59aa26(0x293)](_0x263da6=>new Function(JSON[_0x59aa26(0x2db)](_0x263da6)));break;case _0x59aa26(0x3ed):_0x189fde=_0x383916[_0x42527f]!==''?String(_0x383916[_0x42527f]):'';break;case _0x59aa26(0x2b0):_0x1f4809=_0x383916[_0x42527f]!==''?JSON[_0x59aa26(0x2db)](_0x383916[_0x42527f]):[],_0x189fde=_0x1f4809[_0x59aa26(0x293)](_0x218733=>String(_0x218733));break;case _0x59aa26(0x1fb):_0x19b151=_0x383916[_0x42527f]!==''?JSON[_0x59aa26(0x2db)](_0x383916[_0x42527f]):{},_0x189fde=VisuMZ['ConvertParams']({},_0x19b151);break;case _0x59aa26(0x205):_0x1f4809=_0x383916[_0x42527f]!==''?JSON[_0x59aa26(0x2db)](_0x383916[_0x42527f]):[],_0x189fde=_0x1f4809['map'](_0x14bd38=>VisuMZ[_0x59aa26(0x28b)]({},JSON[_0x59aa26(0x2db)](_0x14bd38)));break;default:continue;}_0x43c491[_0x4ab606]=_0x189fde;}}return _0x43c491;},(_0x232ad1=>{const _0x50e87f=_0x43c6f3,_0x1b875f=_0x232ad1[_0x50e87f(0x38d)];for(const _0x70b728 of dependencies){if(_0x50e87f(0x406)!==_0x50e87f(0x3e2)){if(!Imported[_0x70b728]){alert(_0x50e87f(0x281)['format'](_0x1b875f,_0x70b728)),SceneManager[_0x50e87f(0x3b6)]();break;}}else return;}const _0x3a4e4f=_0x232ad1[_0x50e87f(0x3c0)];if(_0x3a4e4f[_0x50e87f(0x2dd)](/\[Version[ ](.*?)\]/i)){const _0x4dc7bb=Number(RegExp['$1']);_0x4dc7bb!==VisuMZ[label][_0x50e87f(0x26d)]&&(alert(_0x50e87f(0x286)[_0x50e87f(0x343)](_0x1b875f,_0x4dc7bb)),SceneManager[_0x50e87f(0x3b6)]());}if(_0x3a4e4f[_0x50e87f(0x2dd)](/\[Tier[ ](\d+)\]/i)){if('SMDYu'!=='wpjup'){const _0x31a1f6=Number(RegExp['$1']);if(_0x31a1f6<tier){if('JULCi'==='amHKM')return _0x77d81[_0x50e87f(0x32c)];else alert(_0x50e87f(0x212)['format'](_0x1b875f,_0x31a1f6,tier)),SceneManager[_0x50e87f(0x3b6)]();}else{if(_0x50e87f(0x2fa)!=='QaVRY'){const _0x1876ee=_0x32a482['_actionBattlers'][_0x1d4c93];_0x1876ee===_0x201a70&&(_0xf51ee3[_0x50e87f(0x2ec)][_0x1b280f]=this);}else tier=Math['max'](_0x31a1f6,tier);}}else{const _0xd6814e=_0x8dd7a4[_0x50e87f(0x3af)][_0x1ede44];_0xd6814e===_0x4cda8d&&(_0x4d0f87['_otb_actionBattlersNext'][_0x37b557]=this);}}VisuMZ[_0x50e87f(0x28b)](VisuMZ[label][_0x50e87f(0x3f9)],_0x232ad1[_0x50e87f(0x21d)]);})(pluginData),PluginManager[_0x43c6f3(0x28d)](pluginData['name'],_0x43c6f3(0x27c),_0x5a4c6e=>{SceneManager['push'](Scene_Party);}),PluginManager[_0x43c6f3(0x28d)](pluginData['name'],_0x43c6f3(0x267),_0x17f241=>{const _0x677233=_0x43c6f3;if($gameParty[_0x677233(0x1e5)]())return;VisuMZ[_0x677233(0x28b)](_0x17f241,_0x17f241);const _0x2f3a54=_0x17f241[_0x677233(0x284)];$gameParty['changeMaxBattleMembers'](_0x2f3a54);}),PluginManager[_0x43c6f3(0x28d)](pluginData['name'],_0x43c6f3(0x353),_0x2e85da=>{const _0x3bcc6c=_0x43c6f3;if(!SceneManager['isSceneMap']())return;VisuMZ[_0x3bcc6c(0x28b)](_0x2e85da,_0x2e85da);const _0x2acfb0=_0x2e85da['Actors'];for(const _0x54b5f6 of _0x2acfb0){$gameParty[_0x3bcc6c(0x3d6)](_0x54b5f6);}$gamePlayer['refresh']();}),PluginManager[_0x43c6f3(0x28d)](pluginData[_0x43c6f3(0x38d)],_0x43c6f3(0x3a6),_0x8ca292=>{const _0x2a7e41=_0x43c6f3;if(!SceneManager[_0x2a7e41(0x39d)]())return;VisuMZ[_0x2a7e41(0x28b)](_0x8ca292,_0x8ca292);const _0x1cd07b=_0x8ca292[_0x2a7e41(0x2d5)];for(const _0x3555a0 of _0x1cd07b){if($gameParty[_0x2a7e41(0x3c4)]()[_0x2a7e41(0x29d)]<=0x1)break;$gameParty[_0x2a7e41(0x416)](_0x3555a0);}$gamePlayer[_0x2a7e41(0x253)]();}),PluginManager[_0x43c6f3(0x28d)](pluginData[_0x43c6f3(0x38d)],_0x43c6f3(0x1ef),_0x4bb983=>{const _0x482564=_0x43c6f3;if(!SceneManager[_0x482564(0x39d)]())return;if($gameParty[_0x482564(0x3c4)]()[_0x482564(0x29d)]<=0x1)return;if(!$gameParty[_0x482564(0x34c)])return;if($gameParty[_0x482564(0x34c)][_0x482564(0x29d)]<=0x0)return;VisuMZ[_0x482564(0x28b)](_0x4bb983,_0x4bb983);const _0xe7df2e=_0x4bb983['Index'],_0x4e4107=$gameParty[_0x482564(0x34c)][_0xe7df2e];$gameParty[_0x482564(0x416)](_0x4e4107),$gamePlayer[_0x482564(0x253)]();}),PluginManager[_0x43c6f3(0x28d)](pluginData[_0x43c6f3(0x38d)],_0x43c6f3(0x20e),_0xd887e4=>{const _0x12486c=_0x43c6f3;if(!SceneManager[_0x12486c(0x39d)]())return;if($gameParty[_0x12486c(0x3c4)]()[_0x12486c(0x29d)]>=$gameParty['maxBattleMembers']())return;if($gameParty[_0x12486c(0x3e3)]()['length']<=0x0)return;const _0x19c7e0=$gameParty[_0x12486c(0x3e3)](),_0x455f20=_0x19c7e0[Math['floor'](Math[_0x12486c(0x3e7)]()*_0x19c7e0[_0x12486c(0x29d)])],_0x22198b=_0x455f20[_0x12486c(0x24a)]();$gameParty[_0x12486c(0x3d6)](_0x22198b),$gamePlayer['refresh']();}),PluginManager['registerCommand'](pluginData['name'],_0x43c6f3(0x30a),_0x3f1d26=>{const _0xe26d20=_0x43c6f3;VisuMZ[_0xe26d20(0x28b)](_0x3f1d26,_0x3f1d26);const _0x5ec790=_0x3f1d26[_0xe26d20(0x2d5)]['map'](_0x2f7961=>$gameActors[_0xe26d20(0x372)](_0x2f7961))[_0xe26d20(0x399)](null),_0x44fd69=_0x3f1d26[_0xe26d20(0x296)];for(const _0x5b2b2f of _0x5ec790){if(!_0x5b2b2f)continue;_0x5b2b2f['setPartyLock'](_0x44fd69);}}),PluginManager[_0x43c6f3(0x28d)](pluginData['name'],'RequirePartyMembers',_0x3477e4=>{const _0x3c6953=_0x43c6f3;VisuMZ[_0x3c6953(0x28b)](_0x3477e4,_0x3477e4);const _0x490dfa=_0x3477e4[_0x3c6953(0x2d5)][_0x3c6953(0x293)](_0x292222=>$gameActors[_0x3c6953(0x372)](_0x292222))[_0x3c6953(0x399)](null),_0x49af98=_0x3477e4[_0x3c6953(0x3ef)];for(const _0x5c4d81 of _0x490dfa){if(_0x3c6953(0x2d8)===_0x3c6953(0x2a9)){if(this[_0x3c6953(0x2e1)]===_0x3f485d)this[_0x3c6953(0x22d)]();this[_0x3c6953(0x2e1)]=_0x27b7f5;}else{if(!_0x5c4d81)continue;_0x5c4d81[_0x3c6953(0x2ea)](_0x49af98);}}}),ImageManager[_0x43c6f3(0x418)]=VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3f9)][_0x43c6f3(0x327)][_0x43c6f3(0x3c6)],ImageManager[_0x43c6f3(0x314)]=VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3f9)][_0x43c6f3(0x327)][_0x43c6f3(0x23f)],TextManager[_0x43c6f3(0x294)]=VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3f9)][_0x43c6f3(0x3cc)]['ActiveParty'],TextManager[_0x43c6f3(0x409)]=VisuMZ['PartySystem'][_0x43c6f3(0x3f9)][_0x43c6f3(0x3cc)][_0x43c6f3(0x2a6)],TextManager['statusParty']=VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3f9)][_0x43c6f3(0x3cc)][_0x43c6f3(0x323)],TextManager['emptyPartyMember']=VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3f9)]['Vocab'][_0x43c6f3(0x22e)],TextManager['removePartyMember']=VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3f9)][_0x43c6f3(0x3cc)][_0x43c6f3(0x3ff)],TextManager[_0x43c6f3(0x2f5)]=VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3f9)][_0x43c6f3(0x3cc)][_0x43c6f3(0x3da)],TextManager[_0x43c6f3(0x3a7)]=VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3f9)]['Vocab']['AssistRemove'],TextManager['assistSortPartyMembers']=VisuMZ['PartySystem'][_0x43c6f3(0x3f9)]['Vocab'][_0x43c6f3(0x2e6)],TextManager['assistSwapInPartyMember']=VisuMZ[_0x43c6f3(0x36a)]['Settings']['Vocab'][_0x43c6f3(0x200)],TextManager[_0x43c6f3(0x32f)]=VisuMZ[_0x43c6f3(0x36a)]['Settings']['Vocab'][_0x43c6f3(0x28e)],ColorManager['getColor']=function(_0x12068e){const _0x5d3e5c=_0x43c6f3;_0x12068e=String(_0x12068e);if(_0x12068e[_0x5d3e5c(0x2dd)](/#(.*)/i)){if('IAsVs'===_0x5d3e5c(0x40f))return'#%1'[_0x5d3e5c(0x343)](String(RegExp['$1']));else{if(_0x580f4a['VisuMZ_2_BattleSystemSTB']&&_0x2c6393['isSTB']())return!![];return![];}}else return this[_0x5d3e5c(0x20a)](Number(_0x12068e));},SceneManager['isSceneParty']=function(){const _0xeb7bd6=_0x43c6f3;return this[_0xeb7bd6(0x2b4)]&&this[_0xeb7bd6(0x2b4)][_0xeb7bd6(0x226)]===Scene_Party;},SceneManager['isSceneMap']=function(){const _0x5fa08e=_0x43c6f3;return this[_0x5fa08e(0x2b4)]&&this[_0x5fa08e(0x2b4)]['constructor']===Scene_Map;},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x23a)]=BattleManager[_0x43c6f3(0x21e)],BattleManager[_0x43c6f3(0x21e)]=function(_0x34fcca,_0x2beedc,_0x1050f4){const _0x214fdd=_0x43c6f3;VisuMZ[_0x214fdd(0x36a)]['BattleManager_setup'][_0x214fdd(0x3c9)](this,_0x34fcca,_0x2beedc,_0x1050f4),$gameParty['clearPartyBattleCommandCooldown']();},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x297)]=Game_Battler[_0x43c6f3(0x2bb)]['onBattleStart'],Game_Battler[_0x43c6f3(0x2bb)][_0x43c6f3(0x2ce)]=function(_0x241bde){const _0x24f5ff=_0x43c6f3;VisuMZ[_0x24f5ff(0x36a)]['Game_Battler_onBattleStart']['call'](this,_0x241bde);if(this[_0x24f5ff(0x33a)]())this[_0x24f5ff(0x2be)]();},VisuMZ['PartySystem'][_0x43c6f3(0x273)]=Game_Battler['prototype'][_0x43c6f3(0x215)],Game_Battler[_0x43c6f3(0x2bb)][_0x43c6f3(0x215)]=function(){const _0x5ef2c7=_0x43c6f3;VisuMZ[_0x5ef2c7(0x36a)][_0x5ef2c7(0x273)][_0x5ef2c7(0x3c9)](this);if(this[_0x5ef2c7(0x33a)]())this[_0x5ef2c7(0x396)]();},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x340)]=Game_Actor[_0x43c6f3(0x2bb)][_0x43c6f3(0x21e)],Game_Actor[_0x43c6f3(0x2bb)][_0x43c6f3(0x21e)]=function(_0x4d38ae){const _0x5c91bb=_0x43c6f3;VisuMZ[_0x5c91bb(0x36a)][_0x5c91bb(0x340)]['call'](this,_0x4d38ae),this[_0x5c91bb(0x22d)](),this[_0x5c91bb(0x2be)]();},Game_Actor[_0x43c6f3(0x2bb)][_0x43c6f3(0x22d)]=function(){const _0x2fea3b=_0x43c6f3;this[_0x2fea3b(0x219)]=![],this[_0x2fea3b(0x2e1)]=![];},Game_Actor[_0x43c6f3(0x2bb)]['isFormationChangeOk']=function(){const _0x2333d5=_0x43c6f3;if(this[_0x2333d5(0x219)]===undefined)this[_0x2333d5(0x22d)]();return!this[_0x2333d5(0x219)];},Game_Actor[_0x43c6f3(0x2bb)][_0x43c6f3(0x384)]=function(_0x3f398b){const _0x3e6f40=_0x43c6f3;if(this[_0x3e6f40(0x219)]===undefined)this[_0x3e6f40(0x22d)]();this[_0x3e6f40(0x219)]=_0x3f398b;},Game_Actor[_0x43c6f3(0x2bb)][_0x43c6f3(0x25c)]=function(){const _0x1e6097=_0x43c6f3;if(this['_partyRequired']===undefined)this[_0x1e6097(0x22d)]();return this[_0x1e6097(0x2e1)];},Game_Actor['prototype'][_0x43c6f3(0x2ea)]=function(_0x50845c){const _0x3a4dc0=_0x43c6f3;if(this['_partyRequired']===undefined)this[_0x3a4dc0(0x22d)]();this[_0x3a4dc0(0x2e1)]=_0x50845c;},Game_Actor[_0x43c6f3(0x2bb)][_0x43c6f3(0x2be)]=function(){const _0x556bb0=_0x43c6f3;this[_0x556bb0(0x34d)]=0x0;},Game_Actor['prototype'][_0x43c6f3(0x3f0)]=function(){const _0x10db4a=_0x43c6f3;if(this[_0x10db4a(0x34d)]===undefined)this[_0x10db4a(0x2be)]();if(!this[_0x10db4a(0x30f)]())return![];if(this[_0x10db4a(0x25c)]())return![];return this[_0x10db4a(0x34d)]<=0x0;},Game_Actor[_0x43c6f3(0x2bb)]['battlePartySwitchCooldown']=function(){const _0x386316=_0x43c6f3;if(this['_partySwitchBattleCommandCooldown']===undefined)this[_0x386316(0x2be)]();return this[_0x386316(0x34d)];},Game_Actor[_0x43c6f3(0x2bb)]['setBattlePartySwitchCooldown']=function(_0x119b01){const _0x58f297=_0x43c6f3;if(this[_0x58f297(0x34d)]===undefined)this['clearPartySwitchCommandCooldown']();this[_0x58f297(0x34d)]=_0x119b01||0x0;},Game_Actor[_0x43c6f3(0x2bb)][_0x43c6f3(0x348)]=function(){const _0x414f2b=_0x43c6f3;if(this['_partySwitchBattleCommandCooldown']===undefined)this[_0x414f2b(0x2be)]();const _0x5c233b=VisuMZ[_0x414f2b(0x36a)][_0x414f2b(0x3f9)][_0x414f2b(0x327)][_0x414f2b(0x3fc)];this['setBattlePartySwitchCooldown'](_0x5c233b);},Game_Actor[_0x43c6f3(0x2bb)][_0x43c6f3(0x396)]=function(){const _0x32b516=_0x43c6f3;if(this[_0x32b516(0x34d)]===undefined)this['clearPartySwitchCommandCooldown']();this[_0x32b516(0x34d)]--;},Game_Actor[_0x43c6f3(0x2bb)][_0x43c6f3(0x3c1)]=function(_0x3149ca){const _0x36d486=_0x43c6f3;Imported[_0x36d486(0x26b)]&&BattleManager[_0x36d486(0x39e)]()&&BattleManager['updateTurnOrderCTB']();Imported[_0x36d486(0x350)]&&BattleManager[_0x36d486(0x37e)]()&&(BattleManager[_0x36d486(0x2e8)](),BattleManager[_0x36d486(0x313)]=this,BattleManager[_0x36d486(0x245)]=this);if(Imported['VisuMZ_2_BattleSystemBTB']&&BattleManager[_0x36d486(0x24d)]()){if(_0x36d486(0x29e)!==_0x36d486(0x238)){BattleManager[_0x36d486(0x313)]=undefined,BattleManager[_0x36d486(0x245)]=this;const _0x486c72=BattleManager[_0x36d486(0x2ec)][_0x36d486(0x285)](_0x3149ca);BattleManager[_0x36d486(0x2ec)][_0x486c72]=this,BattleManager[_0x36d486(0x234)]();}else return _0x2b21a3[_0x36d486(0x36a)][_0x36d486(0x3f9)]['Window'][_0x36d486(0x332)][_0x36d486(0x3c9)](this);}if(Imported[_0x36d486(0x315)]&&BattleManager[_0x36d486(0x207)]()){if(_0x36d486(0x26e)===_0x36d486(0x26e))BattleManager['_subject']=this,BattleManager[_0x36d486(0x245)]=this;else{if(!this[_0x36d486(0x400)]())return;if(_0x32ca5a[_0x36d486(0x363)](_0x36d486(0x2bc))){const _0x1a4991=this['currentActor']();this['processShiftRemoveShortcut']();}}}if(Imported[_0x36d486(0x317)]&&BattleManager['isOTB']()){if(_0x36d486(0x3dc)!==_0x36d486(0x3dc))this[_0x36d486(0x32e)]()?(this[_0x36d486(0x283)]=!![],this['_logWindow']['addText'](_0x43ff8f[_0x36d486(0x35f)][_0x36d486(0x343)](_0x5cb928['formation']))):this[_0x36d486(0x3db)]();else{BattleManager['_subject']=this,BattleManager[_0x36d486(0x245)]=this;for(let _0x12f4b0=0x0;_0x12f4b0<BattleManager[_0x36d486(0x2ec)][_0x36d486(0x29d)];_0x12f4b0++){if(_0x36d486(0x2de)!==_0x36d486(0x1f3)){const _0x4d6b51=BattleManager[_0x36d486(0x2ec)][_0x12f4b0];_0x4d6b51===_0x3149ca&&(BattleManager['_actionBattlers'][_0x12f4b0]=this);}else _0x2618d1[_0x36d486(0x36a)][_0x36d486(0x366)][_0x36d486(0x3c9)](this),this[_0x36d486(0x30d)](),this[_0x36d486(0x35d)](),this[_0x36d486(0x275)]();}for(let _0x182b2a=0x0;_0x182b2a<BattleManager[_0x36d486(0x3af)]['length'];_0x182b2a++){if(_0x36d486(0x2d0)===_0x36d486(0x2d0)){const _0x1bfe13=BattleManager[_0x36d486(0x3af)][_0x182b2a];_0x1bfe13===_0x3149ca&&(_0x36d486(0x1fe)!==_0x36d486(0x38b)?BattleManager[_0x36d486(0x3af)][_0x182b2a]=this:this[_0x36d486(0x34c)][_0x36d486(0x282)](0x0));}else this[_0x36d486(0x22b)]&&this[_0x36d486(0x22b)][_0x36d486(0x331)](this[_0x36d486(0x372)](this[_0x36d486(0x328)]()));}}}},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x1f7)]=Game_Unit[_0x43c6f3(0x2bb)][_0x43c6f3(0x1e5)],Game_Unit[_0x43c6f3(0x2bb)][_0x43c6f3(0x1e5)]=function(){const _0x4672a9=_0x43c6f3;if(SceneManager[_0x4672a9(0x3fa)]())return![];return VisuMZ[_0x4672a9(0x36a)][_0x4672a9(0x1f7)]['call'](this);},Game_Party[_0x43c6f3(0x272)]=VisuMZ['PartySystem']['Settings'][_0x43c6f3(0x327)][_0x43c6f3(0x3d7)],VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x383)]=Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x288)],Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x288)]=function(){const _0x2b6c7b=_0x43c6f3;VisuMZ[_0x2b6c7b(0x36a)][_0x2b6c7b(0x383)][_0x2b6c7b(0x3c9)](this),this[_0x2b6c7b(0x22a)](),this[_0x2b6c7b(0x2a0)](),this['initBattleMembers']();},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x22a)]=function(){const _0x280733=_0x43c6f3;this[_0x280733(0x2a2)]=0x0;},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x3f0)]=function(){const _0x174fd3=_0x43c6f3;if(this[_0x174fd3(0x2a2)]===undefined)this['clearPartyBattleCommandCooldown']();return this[_0x174fd3(0x2a2)]<=0x0;},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x408)]=function(){const _0x5d9065=_0x43c6f3;if(this[_0x5d9065(0x2a2)]===undefined)this[_0x5d9065(0x22a)]();return this[_0x5d9065(0x2a2)];},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x2b3)]=function(_0xbd0c6e){const _0x25be67=_0x43c6f3;if(this['_partySystemBattleCommandCooldown']===undefined)this[_0x25be67(0x22a)]();this[_0x25be67(0x2a2)]=_0xbd0c6e;},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x348)]=function(){const _0x292df3=_0x43c6f3;if(this[_0x292df3(0x2a2)]===undefined)this['clearPartyBattleCommandCooldown']();this[_0x292df3(0x2a2)]=VisuMZ[_0x292df3(0x36a)]['Settings'][_0x292df3(0x327)][_0x292df3(0x3b1)]||0x0;},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x396)]=function(){const _0x116f7c=_0x43c6f3;if(this['_partySystemBattleCommandCooldown']===undefined)this[_0x116f7c(0x22a)]();this[_0x116f7c(0x2a2)]--;},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x2a0)]=function(){const _0x291cf1=_0x43c6f3;this[_0x291cf1(0x35c)]=0x0;},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x360)]=function(_0x4aefe1){const _0x37202b=_0x43c6f3;this[_0x37202b(0x35c)]=_0x4aefe1,this['initBattleMembers'](!![]),$gamePlayer&&$gamePlayer[_0x37202b(0x35b)]()&&$gamePlayer[_0x37202b(0x35b)]()['changeMaxBattleMembers']();},Game_Followers[_0x43c6f3(0x2bb)][_0x43c6f3(0x360)]=function(){const _0x11bb58=_0x43c6f3;if(!SceneManager[_0x11bb58(0x39d)]())return;this['setup']();const _0x61669=$gameMap[_0x11bb58(0x2b7)](),_0x385620=$gamePlayer['x'],_0x4693cd=$gamePlayer['y'],_0x1bfff9=$gamePlayer['direction']();$gameTemp[_0x11bb58(0x398)]=!![],$gamePlayer[_0x11bb58(0x395)](_0x61669,_0x385620,_0x4693cd,_0x1bfff9,0x0),setTimeout(this[_0x11bb58(0x2df)]['bind'](this),0x7d0);},Game_Followers['prototype'][_0x43c6f3(0x2df)]=function(){const _0x2f1c1b=_0x43c6f3;$gameTemp[_0x2f1c1b(0x398)]=![];},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3ee)]=Scene_Base[_0x43c6f3(0x2bb)][_0x43c6f3(0x3ae)],Scene_Base['prototype'][_0x43c6f3(0x3ae)]=function(){const _0xd53a94=_0x43c6f3;if($gameTemp[_0xd53a94(0x398)])return![];return VisuMZ[_0xd53a94(0x36a)][_0xd53a94(0x3ee)][_0xd53a94(0x3c9)](this);},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x3cd)]=function(){const _0x306bb3=_0x43c6f3;if(this['_battleMaxSize']===undefined)this[_0x306bb3(0x3ac)]();return this[_0x306bb3(0x35c)]||Game_Party[_0x306bb3(0x272)];},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x1ff)]=function(){const _0x452481=_0x43c6f3;if(this['_battleMaxSize']===undefined)this[_0x452481(0x3ac)]();if(!this[_0x452481(0x34c)])this['initBattleMembers']();while(this[_0x452481(0x34c)][_0x452481(0x29d)]<this['_battleMaxSize']){this[_0x452481(0x34c)][_0x452481(0x282)](0x0);}},Game_Party[_0x43c6f3(0x2bb)]['initBattleMembers']=function(_0x163704){const _0x3e43f7=_0x43c6f3;!_0x163704&&(this[_0x3e43f7(0x35c)]=Game_Party[_0x3e43f7(0x272)]);this[_0x3e43f7(0x34c)]=this[_0x3e43f7(0x22f)]['slice'](0x0,this[_0x3e43f7(0x35c)]);while(this['_battleMembers'][_0x3e43f7(0x29d)]<this[_0x3e43f7(0x35c)]){this[_0x3e43f7(0x34c)][_0x3e43f7(0x282)](0x0);}if($gamePlayer)$gamePlayer[_0x3e43f7(0x253)]();},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x3c4)]=function(){const _0x1c4128=_0x43c6f3;return this[_0x1c4128(0x25b)]()[_0x1c4128(0x298)](_0x137853=>!!_0x137853);},Game_Party[_0x43c6f3(0x2bb)]['rawBattleMembers']=function(){const _0x48f79b=_0x43c6f3;this[_0x48f79b(0x1ff)]();const _0x198b8b=this['_battleMembers']['map'](_0x6b4ef3=>$gameActors['actor'](_0x6b4ef3));return SceneManager['isSceneParty']()?_0x198b8b:_0x198b8b['filter'](_0x1a8b4f=>_0x1a8b4f&&_0x1a8b4f[_0x48f79b(0x3a4)]());},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x3e3)]=function(){const _0x167f6b=_0x43c6f3,_0x3f331a=this[_0x167f6b(0x3c4)]();return this[_0x167f6b(0x1ed)]()[_0x167f6b(0x298)](_0x4035d6=>!_0x3f331a['includes'](_0x4035d6));},VisuMZ[_0x43c6f3(0x36a)]['Game_Party_setupStartingMembers']=Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x413)],Game_Party['prototype'][_0x43c6f3(0x413)]=function(){const _0x405530=_0x43c6f3;VisuMZ['PartySystem']['Game_Party_setupStartingMembers'][_0x405530(0x3c9)](this),this[_0x405530(0x3ac)]();},VisuMZ[_0x43c6f3(0x36a)]['Game_Party_setupBattleTest']=Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x32a)],Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x32a)]=function(){const _0x22bef6=_0x43c6f3;VisuMZ['PartySystem'][_0x22bef6(0x2eb)][_0x22bef6(0x3c9)](this),this[_0x22bef6(0x1ee)]();},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x2cd)]=function(){const _0x314505=_0x43c6f3;this[_0x314505(0x35c)]=Game_Party[_0x314505(0x272)],this['_battleMembers']=[],this[_0x314505(0x22f)]=[];for(const _0x32b2e1 of $dataSystem[_0x314505(0x251)]){const _0x110681=$gameActors[_0x314505(0x372)](_0x32b2e1['actorId']);if(!_0x110681)continue;_0x110681['changeLevel'](_0x32b2e1[_0x314505(0x2e9)],![]),_0x110681[_0x314505(0x40e)](_0x32b2e1[_0x314505(0x2bd)]),_0x110681[_0x314505(0x37a)](),this['_battleMembers'][_0x314505(0x282)](_0x32b2e1['actorId']),this[_0x314505(0x22f)][_0x314505(0x282)](_0x32b2e1[_0x314505(0x24a)]);}while(this[_0x314505(0x34c)][_0x314505(0x29d)]<this['_battleMaxSize']){if('diUvn'===_0x314505(0x3b3))this[_0x314505(0x34c)][_0x314505(0x282)](0x0);else{const _0x305604=_0x52e0e4[_0x314505(0x36a)]['Settings'][_0x314505(0x327)];let _0x251a2a=_0x305604[_0x314505(0x1f2)]!==_0x440dbc?_0x305604['BackRectColor']:0x13;return _0x20f37f[_0x314505(0x228)](_0x251a2a);}}while(this['_battleMembers'][_0x314505(0x29d)]>this[_0x314505(0x3cd)]()){this[_0x314505(0x34c)][_0x314505(0x26c)]();}if($gamePlayer)$gamePlayer[_0x314505(0x253)]();},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x1ee)]=function(){const _0x2daeef=_0x43c6f3,_0x56800e=this[_0x2daeef(0x3c4)]();for(let _0x11abb3=0x1;_0x11abb3<$dataActors[_0x2daeef(0x29d)];_0x11abb3++){if(_0x2daeef(0x276)!=='MCkxy')_0x378c5f['_tpbSceneChangeCacheActor']=_0x5549e3[_0x2daeef(0x372)]();else{const _0x4297a2=$gameActors[_0x2daeef(0x372)](_0x11abb3);if(!_0x4297a2)continue;if(_0x4297a2[_0x2daeef(0x38d)]()['length']<=0x0)continue;if(_0x4297a2[_0x2daeef(0x38d)]()[_0x2daeef(0x2dd)](/-----/i))continue;if(_0x56800e[_0x2daeef(0x2c5)](_0x4297a2))continue;this[_0x2daeef(0x22f)][_0x2daeef(0x282)](_0x4297a2[_0x2daeef(0x24a)]());}}},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x261)]=Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x244)],Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x244)]=function(_0x156ecc){const _0x313c7c=_0x43c6f3;VisuMZ[_0x313c7c(0x36a)]['Game_Party_addActor'][_0x313c7c(0x3c9)](this,_0x156ecc),this[_0x313c7c(0x3d6)](_0x156ecc);if(SceneManager[_0x313c7c(0x28f)]()){if('pkoAD'!==_0x313c7c(0x2c8))return _0x3efd68=_0xc470ed(_0x585f74),_0x3d5eb4[_0x313c7c(0x2dd)](/#(.*)/i)?'#%1'[_0x313c7c(0x343)](_0x1c698b(_0x290358['$1'])):this[_0x313c7c(0x20a)](_0x1c14f7(_0x258866));else Imported[_0x313c7c(0x317)]&&BattleManager[_0x313c7c(0x342)]()&&(BattleManager[_0x313c7c(0x211)](),BattleManager[_0x313c7c(0x326)]($gameActors['actor'](_0x156ecc)));}},Game_Party[_0x43c6f3(0x2bb)]['addActorToBattleMembers']=function(_0x15441a){const _0x3d2379=_0x43c6f3;this[_0x3d2379(0x1ff)]();if(this[_0x3d2379(0x34c)]['includes'](_0x15441a))return;if(!this['_actors'][_0x3d2379(0x2c5)](_0x15441a))return;if(!this[_0x3d2379(0x34c)][_0x3d2379(0x2c5)](0x0))return;const _0x30c502=$gameActors[_0x3d2379(0x372)](_0x15441a);if(!_0x30c502)return;const _0x40ca2b=this[_0x3d2379(0x34c)][_0x3d2379(0x285)](0x0);if(_0x40ca2b<0x0)return;this[_0x3d2379(0x34c)][_0x40ca2b]=_0x15441a,SceneManager[_0x3d2379(0x28f)]()&&(_0x30c502[_0x3d2379(0x2ce)](),_0x30c502[_0x3d2379(0x377)]()),this['partyChangeRefresh']();},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x2b1)]=function(_0x426f8f,_0xdabb53){const _0x6aa1b=_0x43c6f3;this[_0x6aa1b(0x1ff)]();if(this['_battleMembers'][_0x6aa1b(0x2c5)](_0x426f8f))return;if(!this[_0x6aa1b(0x34c)]['includes'](0x0))return;const _0x5d1777=$gameActors[_0x6aa1b(0x372)](_0x426f8f);if(!_0x5d1777)return;this['_battleMembers'][_0xdabb53]=_0x426f8f,_0x5d1777[_0x6aa1b(0x377)](),this[_0x6aa1b(0x2b2)]();},VisuMZ['PartySystem']['Game_Party_removeActor']=Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x220)],Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x220)]=function(_0x1d98a9){const _0x41e297=_0x43c6f3;this[_0x41e297(0x416)](_0x1d98a9),VisuMZ[_0x41e297(0x36a)][_0x41e297(0x255)]['call'](this,_0x1d98a9);},Game_Party[_0x43c6f3(0x2bb)]['removeActorFromBattleMembers']=function(_0x5d490d){const _0x76a25b=_0x43c6f3;this[_0x76a25b(0x1ff)]();if(!this[_0x76a25b(0x34c)][_0x76a25b(0x2c5)](_0x5d490d))return;if(_0x5d490d<=0x0)return;const _0x4e488c=this['_battleMembers'][_0x76a25b(0x285)](_0x5d490d);this['_battleMembers'][_0x4e488c]=0x0,this[_0x76a25b(0x22f)]['remove'](_0x5d490d),this['_actors'][_0x76a25b(0x282)](_0x5d490d),this[_0x76a25b(0x2b2)]();},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x2b2)]=function(){const _0x1ff402=_0x43c6f3;this[_0x1ff402(0x365)](),$gamePlayer[_0x1ff402(0x253)](),$gameMap[_0x1ff402(0x2e3)]();},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x365)]=function(){const _0x14cadd=_0x43c6f3;this['checkInitBattleMembers']();const _0x212d3f=this[_0x14cadd(0x3c4)]()[_0x14cadd(0x2a1)](this[_0x14cadd(0x3e3)]());this[_0x14cadd(0x22f)]=_0x212d3f[_0x14cadd(0x293)](_0xcd2e57=>_0xcd2e57?_0xcd2e57[_0x14cadd(0x24a)]():0x0)[_0x14cadd(0x399)](0x0);},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x24b)]=function(){const _0x3e1187=_0x43c6f3;this[_0x3e1187(0x22f)]['sort']((_0x52da90,_0x39a03)=>_0x52da90-_0x39a03),this[_0x3e1187(0x365)](),this[_0x3e1187(0x2b2)]();},Game_Party[_0x43c6f3(0x2bb)]['anyRequiredPartyMembersInReserve']=function(){const _0x14d539=_0x43c6f3;for(const _0x49e60f of this[_0x14d539(0x3e3)]()){if('DbMpW'!=='XpDaQ'){if(!_0x49e60f)continue;if(_0x49e60f['isRequiredInParty']())return!![];}else{const _0x154e05='actor%1-stateIcon'['format'](_0x26265f['actorId']()),_0x24b14d=this['createInnerSprite'](_0x154e05,_0x36b59e);_0x24b14d[_0x14d539(0x21e)](_0x1b01c8);}}return![];},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3fb)]=Game_Party['prototype'][_0x43c6f3(0x30b)],Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x30b)]=function(_0x4d7976,_0x48649a){const _0x15ab68=_0x43c6f3;VisuMZ['PartySystem'][_0x15ab68(0x3fb)]['call'](this,_0x4d7976,_0x48649a),this['swapOrderPartySystemPlugin'](_0x4d7976,_0x48649a);},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x23c)]=function(_0x469645,_0x3e9564){const _0x2bfe17=_0x43c6f3;this['_battleMembers']=[];for(let _0x136332=0x0;_0x136332<this[_0x2bfe17(0x22f)][_0x2bfe17(0x29d)];_0x136332++){if(this[_0x2bfe17(0x34c)][_0x2bfe17(0x29d)]>=this[_0x2bfe17(0x3cd)]())break;this['_battleMembers'][_0x136332]=this[_0x2bfe17(0x22f)][_0x136332];}$gamePlayer[_0x2bfe17(0x253)]();},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3c2)]=Game_Troop[_0x43c6f3(0x2bb)]['increaseTurn'],Game_Troop['prototype'][_0x43c6f3(0x38e)]=function(){const _0x3c756a=_0x43c6f3;VisuMZ[_0x3c756a(0x36a)][_0x3c756a(0x3c2)][_0x3c756a(0x3c9)](this),$gameParty['updateBattlePartySwitchCooldown']();},Scene_Menu['prototype'][_0x43c6f3(0x289)]=function(){SceneManager['push'](Scene_Party);};function Scene_Party(){const _0x4711c4=_0x43c6f3;this[_0x4711c4(0x288)](...arguments);}Scene_Party[_0x43c6f3(0x2bb)]=Object['create'](Scene_MenuBase[_0x43c6f3(0x2bb)]),Scene_Party[_0x43c6f3(0x2bb)]['constructor']=Scene_Party,Scene_Party['prototype'][_0x43c6f3(0x288)]=function(){const _0x29a903=_0x43c6f3;this['loadPartyImages'](),Scene_MenuBase[_0x29a903(0x2bb)]['initialize'][_0x29a903(0x3c9)](this);},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x33c)]=function(){const _0x68e367=_0x43c6f3;if(ConfigManager[_0x68e367(0x1f1)]&&ConfigManager[_0x68e367(0x32c)]!==undefined){if('OLnkh'===_0x68e367(0x214))this[_0x68e367(0x2b9)]=_0x1dd12b['min'](this[_0x68e367(0x2b9)],this[_0x68e367(0x335)]()-0x1),this[_0x68e367(0x202)](this[_0x68e367(0x2b9)]),this[_0x68e367(0x1f9)](!![]),this[_0x68e367(0x3bb)]=!![];else return ConfigManager[_0x68e367(0x32c)];}else{if(ConfigManager[_0x68e367(0x1f1)]===![]){if(_0x68e367(0x23d)===_0x68e367(0x256))_0x2cd98f[_0x68e367(0x2bb)][_0x68e367(0x25e)][_0x68e367(0x3c9)](this,_0x5382f2);else return![];}else{if(_0x68e367(0x41b)!==_0x68e367(0x41b)){if(!_0x3cd23e[_0x68e367(0x39d)]())return;if(_0x241f5e['battleMembers']()[_0x68e367(0x29d)]>=_0x4435db[_0x68e367(0x3cd)]())return;if(_0x55ee90['reserveMembers']()[_0x68e367(0x29d)]<=0x0)return;const _0x34b3b2=_0x2f8734[_0x68e367(0x3e3)](),_0x474b95=_0x34b3b2[_0x3910a5['floor'](_0x1c78ad[_0x68e367(0x3e7)]()*_0x34b3b2['length'])],_0x1ab876=_0x474b95['actorId']();_0x2e64a0[_0x68e367(0x3d6)](_0x1ab876),_0xa60adc[_0x68e367(0x253)]();}else return Scene_MenuBase[_0x68e367(0x2bb)][_0x68e367(0x33c)][_0x68e367(0x3c9)](this);}}},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x3ce)]=function(){return 0x0;},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x403)]=function(){return!![];},Scene_Party['prototype'][_0x43c6f3(0x37c)]=function(){const _0x340e24=_0x43c6f3;Scene_MenuBase[_0x340e24(0x2bb)]['createPageButtons'][_0x340e24(0x3c9)](this),this[_0x340e24(0x1f4)]['_clickHandler']=undefined,this['_pagedownButton'][_0x340e24(0x2bf)]=undefined;},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x351)]=function(){const _0x495fae=_0x43c6f3;for(const _0x8a9481 of $gameParty['members']()){ImageManager[_0x495fae(0x35a)](_0x8a9481[_0x495fae(0x3d2)]()),ImageManager[_0x495fae(0x24f)](_0x8a9481[_0x495fae(0x21c)]()),ImageManager[_0x495fae(0x404)](_0x8a9481[_0x495fae(0x386)]());}},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x401)]=function(){const _0x1bff22=_0x43c6f3;Scene_MenuBase[_0x1bff22(0x2bb)][_0x1bff22(0x401)][_0x1bff22(0x3c9)](this),this[_0x1bff22(0x3bd)](),this[_0x1bff22(0x39c)](),this['createReservePartyLabel'](),this[_0x1bff22(0x410)](),this[_0x1bff22(0x2f8)](),this[_0x1bff22(0x237)]();},Scene_Party['prototype'][_0x43c6f3(0x3bd)]=function(){const _0x15235a=_0x43c6f3,_0x5cf156=this[_0x15235a(0x3ea)]();this[_0x15235a(0x262)]=new Window_PartyLabel(_0x5cf156,TextManager[_0x15235a(0x294)]),this[_0x15235a(0x262)]['setBackgroundType'](VisuMZ[_0x15235a(0x36a)]['Settings'][_0x15235a(0x3e6)][_0x15235a(0x376)]),this['addWindow'](this['_activePartyLabel']);},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x3ea)]=function(){const _0x1fb7bc=_0x43c6f3;return VisuMZ[_0x1fb7bc(0x36a)][_0x1fb7bc(0x3f9)]['Window'][_0x1fb7bc(0x397)][_0x1fb7bc(0x3c9)](this);},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x39c)]=function(){const _0x492edd=_0x43c6f3,_0xcb3998=this[_0x492edd(0x337)]();this['_activePartyWindow']=new Window_PartyActive(_0xcb3998),this[_0x492edd(0x295)][_0x492edd(0x3b7)](VisuMZ[_0x492edd(0x36a)][_0x492edd(0x3f9)][_0x492edd(0x3e6)][_0x492edd(0x208)]),this[_0x492edd(0x295)][_0x492edd(0x336)]('ok',this[_0x492edd(0x29b)][_0x492edd(0x1e9)](this)),this[_0x492edd(0x295)][_0x492edd(0x336)](_0x492edd(0x338),this[_0x492edd(0x39a)][_0x492edd(0x1e9)](this)),this[_0x492edd(0x3e0)](this['_activePartyWindow']);},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x337)]=function(){const _0x21ff3a=_0x43c6f3;return VisuMZ['PartySystem'][_0x21ff3a(0x3f9)][_0x21ff3a(0x3e6)][_0x21ff3a(0x2c0)][_0x21ff3a(0x3c9)](this);},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x29b)]=function(){const _0x1e1b7f=_0x43c6f3;this[_0x1e1b7f(0x344)][_0x1e1b7f(0x21a)](),this['_reservePartyWindow']['reselect']();},Scene_Party['prototype'][_0x43c6f3(0x3f5)]=function(){const _0x3e7090=_0x43c6f3,_0x2a886a=this['reservePartyLabelRect']();this['_reservePartyLabel']=new Window_PartyLabel(_0x2a886a,TextManager[_0x3e7090(0x409)]),this[_0x3e7090(0x1f6)][_0x3e7090(0x3b7)](VisuMZ[_0x3e7090(0x36a)]['Settings'][_0x3e7090(0x3e6)][_0x3e7090(0x41c)]),this[_0x3e7090(0x3e0)](this[_0x3e7090(0x1f6)]);},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x345)]=function(){const _0x5cf471=_0x43c6f3;return VisuMZ[_0x5cf471(0x36a)][_0x5cf471(0x3f9)][_0x5cf471(0x3e6)][_0x5cf471(0x332)][_0x5cf471(0x3c9)](this);},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x410)]=function(){const _0x350df7=_0x43c6f3,_0x4e8bdf=this[_0x350df7(0x27d)]();this[_0x350df7(0x344)]=new Window_PartyReserve(_0x4e8bdf),this[_0x350df7(0x344)][_0x350df7(0x3b7)](VisuMZ[_0x350df7(0x36a)][_0x350df7(0x3f9)]['Window'][_0x350df7(0x415)]),this[_0x350df7(0x344)]['setHandler']('ok',this[_0x350df7(0x291)][_0x350df7(0x1e9)](this)),this[_0x350df7(0x344)][_0x350df7(0x336)](_0x350df7(0x338),this[_0x350df7(0x268)]['bind'](this)),this[_0x350df7(0x3e0)](this[_0x350df7(0x344)]);},Scene_Party[_0x43c6f3(0x2bb)]['reservePartyWindowRect']=function(){const _0x3077d2=_0x43c6f3;return VisuMZ[_0x3077d2(0x36a)]['Settings'][_0x3077d2(0x3e6)]['ReservePartyWindowRect'][_0x3077d2(0x3c9)](this);},Scene_Party['prototype'][_0x43c6f3(0x291)]=function(){const _0x18bbb9=_0x43c6f3,_0x51f120=this['_reservePartyWindow']['pendingIndex'](),_0x533b75=this[_0x18bbb9(0x295)][_0x18bbb9(0x1fc)]();if(_0x51f120<0x0){if(_0x533b75)$gameParty[_0x18bbb9(0x416)](_0x533b75[_0x18bbb9(0x24a)]());}else{if('qrgLb'==='qrgLb'){const _0x51b768=this['_reservePartyWindow'][_0x18bbb9(0x1fc)]()[_0x18bbb9(0x24a)](),_0x279f31=this['_activePartyWindow'][_0x18bbb9(0x328)]();if(_0x533b75)$gameParty[_0x18bbb9(0x416)](_0x533b75[_0x18bbb9(0x24a)]());$gameParty['addActorToBattleMembersAtIndex'](_0x51b768,_0x279f31);}else return this['partySwitchWindowRectStandard']();}this[_0x18bbb9(0x3f6)](),this[_0x18bbb9(0x268)]();},Scene_Party['prototype'][_0x43c6f3(0x3f6)]=function(){const _0x44f24c=_0x43c6f3;this[_0x44f24c(0x295)][_0x44f24c(0x253)](),this[_0x44f24c(0x344)][_0x44f24c(0x253)]();},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x268)]=function(){const _0x557eeb=_0x43c6f3;this[_0x557eeb(0x344)][_0x557eeb(0x39f)](),this['_reservePartyWindow'][_0x557eeb(0x407)](),this[_0x557eeb(0x295)][_0x557eeb(0x21a)]();},Scene_Party['prototype'][_0x43c6f3(0x2f8)]=function(){const _0x5d4dd6=_0x43c6f3,_0x5b1553=this['statusLabelRect']();this[_0x5d4dd6(0x2fd)]=new Window_PartyLabel(_0x5b1553,TextManager[_0x5d4dd6(0x260)]),this['_statusPartyLabel'][_0x5d4dd6(0x3b7)](VisuMZ[_0x5d4dd6(0x36a)]['Settings']['Window'][_0x5d4dd6(0x2f6)]),this['addWindow'](this[_0x5d4dd6(0x2fd)]);},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x25f)]=function(){const _0x4b9030=_0x43c6f3;return VisuMZ[_0x4b9030(0x36a)][_0x4b9030(0x3f9)][_0x4b9030(0x3e6)][_0x4b9030(0x361)][_0x4b9030(0x3c9)](this);},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x237)]=function(){const _0x159f7a=_0x43c6f3,_0x225899=this[_0x159f7a(0x1e8)]();this['_statusPartyWindow']=new Window_PartyStatus(_0x225899),this[_0x159f7a(0x265)][_0x159f7a(0x3b7)](VisuMZ[_0x159f7a(0x36a)][_0x159f7a(0x3f9)][_0x159f7a(0x3e6)][_0x159f7a(0x3e9)]),this[_0x159f7a(0x3e0)](this[_0x159f7a(0x265)]),this['_reservePartyWindow']['setStatusWindow'](this['_statusPartyWindow']),this[_0x159f7a(0x295)][_0x159f7a(0x3f4)](this[_0x159f7a(0x265)]);},Scene_Party[_0x43c6f3(0x2bb)]['statusWindowRect']=function(){const _0xe7ed55=_0x43c6f3;return VisuMZ[_0xe7ed55(0x36a)]['Settings']['Window']['StatusWindowRect']['call'](this);},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x2cc)]=function(){const _0x377e01=_0x43c6f3;return TextManager[_0x377e01(0x230)](_0x377e01(0x2bc));},Scene_Party[_0x43c6f3(0x2bb)]['buttonAssistText1']=function(){return TextManager['assistSwapPositions'];},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x2d1)]=function(){const _0x54d536=_0x43c6f3,_0x3fbed8=this[_0x54d536(0x295)],_0x5b6fb2=this[_0x54d536(0x344)];if(_0x3fbed8&&_0x3fbed8['active']&&_0x3fbed8['currentActor']()&&_0x3fbed8['isShiftRemoveShortcutEnabled']()){if(_0x54d536(0x3e1)===_0x54d536(0x3e1))return TextManager[_0x54d536(0x3a7)];else _0x4698b1['prototype']['initialize']['call'](this,_0x252333),this[_0x54d536(0x2b9)]=0x0,this['refresh']();}else return _0x5b6fb2&&_0x5b6fb2[_0x54d536(0x34b)]&&$gameParty[_0x54d536(0x3e3)]()[_0x54d536(0x29d)]>0x0?TextManager['assistSortPartyMembers']:'';},Scene_Party[_0x43c6f3(0x2bb)]['buttonAssistText4']=function(){const _0x5b3792=_0x43c6f3;if(this[_0x5b3792(0x295)]&&this['_activePartyWindow'][_0x5b3792(0x34b)])return TextManager['assistSwapOutPartyMember'];else return this['_reservePartyWindow']&&this[_0x5b3792(0x344)][_0x5b3792(0x34b)]?TextManager['assistSwapInPartyMember']:Scene_MenuBase['prototype'][_0x5b3792(0x2d7)]['call'](this);},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x40c)]=function(){const _0xf39814=_0x43c6f3;Scene_MenuBase['prototype']['createBackground']['call'](this),this['setBackgroundOpacity'](this[_0xf39814(0x3d5)]()),this[_0xf39814(0x36f)]();},Scene_Party['prototype'][_0x43c6f3(0x3d5)]=function(){const _0x369341=_0x43c6f3;return VisuMZ[_0x369341(0x36a)]['Settings'][_0x369341(0x322)][_0x369341(0x419)];},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x36f)]=function(){const _0x4c7f58=_0x43c6f3,_0x3f20eb={'BgFilename1':VisuMZ[_0x4c7f58(0x36a)]['Settings'][_0x4c7f58(0x322)][_0x4c7f58(0x2c1)],'BgFilename2':VisuMZ[_0x4c7f58(0x36a)][_0x4c7f58(0x3f9)]['BgSettings'][_0x4c7f58(0x27f)]};if(_0x3f20eb&&(_0x3f20eb[_0x4c7f58(0x2c1)]!==''||_0x3f20eb[_0x4c7f58(0x27f)]!=='')){if(_0x4c7f58(0x263)==='tlJkL')this[_0x4c7f58(0x39b)]=new Sprite(ImageManager[_0x4c7f58(0x31d)](_0x3f20eb[_0x4c7f58(0x2c1)])),this[_0x4c7f58(0x41d)]=new Sprite(ImageManager[_0x4c7f58(0x36e)](_0x3f20eb['BgFilename2'])),this['addChild'](this[_0x4c7f58(0x39b)]),this[_0x4c7f58(0x385)](this['_backSprite2']),this[_0x4c7f58(0x39b)]['bitmap']['addLoadListener'](this[_0x4c7f58(0x324)]['bind'](this,this[_0x4c7f58(0x39b)])),this[_0x4c7f58(0x41d)][_0x4c7f58(0x3e8)][_0x4c7f58(0x2d4)](this[_0x4c7f58(0x324)][_0x4c7f58(0x1e9)](this,this[_0x4c7f58(0x41d)]));else return _0x335480[_0x4c7f58(0x36a)]['Settings'][_0x4c7f58(0x327)][_0x4c7f58(0x24e)];}},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x324)]=function(_0x9e583d){const _0x9625e0=_0x43c6f3;this['scaleSprite'](_0x9e583d),this[_0x9625e0(0x269)](_0x9e583d);},Scene_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x367)]=function(){const _0x222434=_0x43c6f3;Scene_MenuBase[_0x222434(0x2bb)][_0x222434(0x367)][_0x222434(0x3c9)](this),$gameParty[_0x222434(0x2b2)]();},Window_StatusBase['prototype'][_0x43c6f3(0x2ed)]=function(_0x5e3269,_0x5579fe,_0x5116a5,_0x40c425){const _0x2ab81b=_0x43c6f3;if(!_0x5e3269)return;_0x40c425?this[_0x2ab81b(0x225)](_0x5e3269,_0x5579fe,_0x5116a5):this[_0x2ab81b(0x36b)](_0x5e3269,_0x5579fe,_0x5116a5);},Window_StatusBase[_0x43c6f3(0x2bb)][_0x43c6f3(0x36b)]=function(_0x2ff449,_0x2671cc,_0x22e891){const _0x446f00=_0x43c6f3;_0x22e891+=Math[_0x446f00(0x31e)]((this['lineHeight']()-ImageManager[_0x446f00(0x2b5)])/0x2),!_0x2ff449[_0x446f00(0x30f)]()&&(_0x446f00(0x393)!==_0x446f00(0x393)?(_0x21525a['PartySystem']['Game_Troop_increaseTurn'][_0x446f00(0x3c9)](this),_0x7828f0['updateBattlePartySwitchCooldown']()):(this[_0x446f00(0x3f3)](ImageManager[_0x446f00(0x418)],_0x2671cc,_0x22e891),_0x2671cc+=ImageManager[_0x446f00(0x299)]+0x4)),_0x2ff449[_0x446f00(0x25c)]()&&(this[_0x446f00(0x3f3)](ImageManager['requiredPartyMemberIcon'],_0x2671cc,_0x22e891),_0x2671cc+=ImageManager[_0x446f00(0x299)]+0x4);},Window_StatusBase['prototype'][_0x43c6f3(0x225)]=function(_0x2f5c43,_0x33a31f,_0x3f4bb0){const _0x1b3e48=_0x43c6f3;let _0x225273=0x0;if(!_0x2f5c43[_0x1b3e48(0x30f)]())_0x225273+=0x1;if(_0x2f5c43[_0x1b3e48(0x25c)]())_0x225273+=0x1;if(_0x225273<=0x1)return _0x1b3e48(0x280)===_0x1b3e48(0x280)?this[_0x1b3e48(0x36b)](_0x2f5c43,_0x33a31f,_0x3f4bb0):_0x5baddf['assistSwapOutPartyMember'];_0x3f4bb0+=Math[_0x1b3e48(0x31e)]((this['lineHeight']()-ImageManager[_0x1b3e48(0x2b5)])/0x2),_0x3f4bb0-=Math[_0x1b3e48(0x31e)](this[_0x1b3e48(0x2ca)]()/0x2),this[_0x1b3e48(0x3f3)](ImageManager[_0x1b3e48(0x418)],_0x33a31f,_0x3f4bb0),_0x3f4bb0+=this[_0x1b3e48(0x2ca)](),this[_0x1b3e48(0x3f3)](ImageManager['requiredPartyMemberIcon'],_0x33a31f,_0x3f4bb0);};function Window_PartyLabel(){const _0x1090f6=_0x43c6f3;this[_0x1090f6(0x288)](...arguments);}Window_PartyLabel[_0x43c6f3(0x2bb)]=Object[_0x43c6f3(0x401)](Window_Base[_0x43c6f3(0x2bb)]),Window_PartyLabel['prototype'][_0x43c6f3(0x226)]=Window_PartyLabel,Window_PartyLabel[_0x43c6f3(0x2bb)][_0x43c6f3(0x288)]=function(_0x52ee8b,_0x31ec7e){const _0x4cb8fa=_0x43c6f3;Window_Base[_0x4cb8fa(0x2bb)][_0x4cb8fa(0x288)]['call'](this,_0x52ee8b),this['setText'](_0x31ec7e);},Window_PartyLabel[_0x43c6f3(0x2bb)]['updatePadding']=function(){this['padding']=0x0;},Window_PartyLabel[_0x43c6f3(0x2bb)]['setText']=function(_0x5a18f6){const _0x46e993=_0x43c6f3;this['contents']['clear'](),this[_0x46e993(0x375)](_0x5a18f6,0x0,0x0,this[_0x46e993(0x21b)],_0x46e993(0x417));};function Window_PartyActive(){const _0x159c27=_0x43c6f3;this[_0x159c27(0x288)](...arguments);}Window_PartyActive[_0x43c6f3(0x2bb)]=Object[_0x43c6f3(0x401)](Window_StatusBase[_0x43c6f3(0x2bb)]),Window_PartyActive['prototype'][_0x43c6f3(0x226)]=Window_PartyActive,Window_PartyActive[_0x43c6f3(0x402)]=VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3f9)]['Window'][_0x43c6f3(0x319)],Window_PartyActive[_0x43c6f3(0x2bb)]['initialize']=function(_0x49589f){const _0x40be0e=_0x43c6f3;Window_StatusBase[_0x40be0e(0x2bb)][_0x40be0e(0x288)][_0x40be0e(0x3c9)](this,_0x49589f),this['refresh'](),this[_0x40be0e(0x21a)](),this[_0x40be0e(0x202)](0x0);},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x29c)]=function(){const _0x3d3180=_0x43c6f3;return VisuMZ[_0x3d3180(0x36a)][_0x3d3180(0x3f9)][_0x3d3180(0x327)][_0x3d3180(0x2d2)];},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x335)]=function(){const _0x226d4a=_0x43c6f3;return $gameParty[_0x226d4a(0x3cd)]();},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x3d8)]=function(){const _0xb5f432=_0x43c6f3;return $gameParty[_0xb5f432(0x3cd)]();},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x34a)]=function(){const _0x5f279e=_0x43c6f3;return this[_0x5f279e(0x27a)];},Window_PartyActive[_0x43c6f3(0x2bb)]['actor']=function(_0x3fa41b){const _0x4cee60=_0x43c6f3;return $gameParty[_0x4cee60(0x25b)]()[_0x3fa41b];},Window_PartyActive['prototype'][_0x43c6f3(0x1fc)]=function(){const _0x570a59=_0x43c6f3;return this[_0x570a59(0x372)](this[_0x570a59(0x328)]());},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x2ee)]=function(){const _0x496deb=_0x43c6f3,_0x1fdc71=this[_0x496deb(0x372)](this['index']());return _0x1fdc71?_0x1fdc71[_0x496deb(0x30f)]():!![];},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x414)]=function(){const _0x11a0e6=_0x43c6f3;if($gameParty[_0x11a0e6(0x3a3)]()[_0x11a0e6(0x29d)]<=0x0)return!![];if($gameParty[_0x11a0e6(0x232)]())return![];return $gameParty[_0x11a0e6(0x3c4)]()[_0x11a0e6(0x29d)]>0x0;},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x3bf)]=function(){const _0x4c8bba=_0x43c6f3;Window_StatusBase[_0x4c8bba(0x2bb)][_0x4c8bba(0x3bf)]['call'](this),this['checkShiftRemoveShortcut']();},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x279)]=function(_0x535f4e){const _0x4e12a6=_0x43c6f3;this[_0x4e12a6(0x40a)]()&&this[_0x4e12a6(0x34e)]();},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x2f4)]=function(){const _0x480752=_0x43c6f3,_0x1dc2bb=this[_0x480752(0x328)](),_0x14adc0=_0x1dc2bb+0x1>=this['maxItems']()?0x0:_0x1dc2bb+0x1;this[_0x480752(0x31c)](_0x1dc2bb,_0x14adc0);},Window_PartyActive['prototype'][_0x43c6f3(0x29a)]=function(){const _0x141747=_0x43c6f3,_0x11fbb0=this[_0x141747(0x328)](),_0x378172=_0x11fbb0-0x1<0x0?this[_0x141747(0x335)]()-0x1:_0x11fbb0-0x1;this[_0x141747(0x31c)](_0x11fbb0,_0x378172);},Window_PartyActive[_0x43c6f3(0x2bb)]['quickSwap']=function(_0x45c98d,_0x21bc79){const _0x2abdbd=_0x43c6f3,_0x5d9a7c=this[_0x2abdbd(0x372)](_0x45c98d),_0xaf178=this[_0x2abdbd(0x372)](_0x21bc79);if(_0x5d9a7c&&!_0x5d9a7c['isFormationChangeOk']())return;if(_0xaf178&&!_0xaf178[_0x2abdbd(0x30f)]())return;const _0x441ed2=$gameParty[_0x2abdbd(0x34c)];_0x441ed2[_0x45c98d]=_0xaf178?_0xaf178[_0x2abdbd(0x24a)]():0x0,_0x441ed2[_0x21bc79]=_0x5d9a7c?_0x5d9a7c[_0x2abdbd(0x24a)]():0x0,this[_0x2abdbd(0x253)](),this[_0x2abdbd(0x388)](),this[_0x2abdbd(0x202)](_0x21bc79);},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x334)]=function(){const _0x551b2b=_0x43c6f3;if(!this[_0x551b2b(0x400)]())return;if(Input[_0x551b2b(0x363)](_0x551b2b(0x2bc))){const _0x147db5=this[_0x551b2b(0x1fc)]();this[_0x551b2b(0x379)]();}},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x379)]=function(){const _0x2cf48c=_0x43c6f3;SoundManager[_0x2cf48c(0x250)]();const _0x46edfb=this[_0x2cf48c(0x1fc)]();$gameParty['removeActorFromBattleMembers'](_0x46edfb[_0x2cf48c(0x24a)]()),this['callUpdateHelp'](),SceneManager[_0x2cf48c(0x2b4)]['refreshAllWindows']();},Window_PartyActive[_0x43c6f3(0x2bb)]['isShiftRemoveShortcutEnabled']=function(){const _0x2721b0=_0x43c6f3;if(!this['addRemoveCommand']())return![];const _0x1e5387=this[_0x2721b0(0x1fc)]();return this['active']&&_0x1e5387&&_0x1e5387['isFormationChangeOk']();},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x274)]=function(_0xc4a311){const _0x235b30=_0x43c6f3,_0x483b88=this['actor'](_0xc4a311);if(!_0x483b88)return this[_0x235b30(0x37b)](_0xc4a311);this[_0x235b30(0x271)]();const _0x50a104=this['itemRect'](_0xc4a311);this[_0x235b30(0x370)](_0xc4a311);const _0x2e7ddc=_0x50a104['y']+_0x50a104[_0x235b30(0x3bc)]-this[_0x235b30(0x2ca)]();this['drawDarkRect'](_0x50a104['x'],_0x2e7ddc,_0x50a104['width'],0x2),this[_0x235b30(0x2ed)](_0x483b88,_0x50a104['x']+0x2,_0x50a104['y']),this['drawActorName'](_0x483b88,_0x50a104['x'],_0x2e7ddc,_0x50a104['width']);},Window_PartyActive['prototype'][_0x43c6f3(0x37b)]=function(_0x3b10eb){const _0x5baf58=_0x43c6f3;this[_0x5baf58(0x271)]();const _0x181449=this[_0x5baf58(0x341)](_0x3b10eb);this[_0x5baf58(0x349)](_0x181449['x'],_0x181449['y'],_0x181449[_0x5baf58(0x235)],_0x181449[_0x5baf58(0x3bc)]);const _0x2c660c=_0x181449['y']+Math['round']((_0x181449['height']-this[_0x5baf58(0x2ca)]())/0x2);this[_0x5baf58(0x3be)](ColorManager['systemColor']()),this[_0x5baf58(0x375)](TextManager[_0x5baf58(0x329)],_0x181449['x'],_0x2c660c,_0x181449[_0x5baf58(0x235)],_0x5baf58(0x417));},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x349)]=function(_0x27dbeb,_0x55cf4e,_0x53c5d7,_0x1699a5,_0x4906d6){const _0x1a33c2=_0x43c6f3;_0x4906d6=Math[_0x1a33c2(0x33f)](_0x4906d6||0x1,0x1);while(_0x4906d6--){_0x1699a5=_0x1699a5||this[_0x1a33c2(0x2ca)](),this['contents'][_0x1a33c2(0x3b0)]=0xa0;const _0x7db5ab=ColorManager['gaugeBackColor']();this[_0x1a33c2(0x20c)]['fillRect'](_0x27dbeb+0x1,_0x55cf4e+0x1,_0x53c5d7-0x2,_0x1699a5-0x2,_0x7db5ab),this[_0x1a33c2(0x20c)]['paintOpacity']=0xff;}},Window_PartyActive['prototype'][_0x43c6f3(0x370)]=function(_0x16d949){const _0x238fcc=_0x43c6f3;switch(Window_PartyActive[_0x238fcc(0x402)]['toLowerCase']()['trim']()){case'face':this['drawItemImageFace'](_0x16d949);break;case'sprite':this[_0x238fcc(0x3aa)](_0x16d949);break;case _0x238fcc(0x3b5):if(Imported[_0x238fcc(0x2d9)]){if(_0x238fcc(0x2b6)!==_0x238fcc(0x1fd))this[_0x238fcc(0x40d)](_0x16d949);else{const _0x3447f9=this[_0x238fcc(0x2ac)][_0x238fcc(0x1fc)]();_0x3447f9?this[_0x238fcc(0x3f2)](_0x3447f9):(this[_0x238fcc(0x2ac)]['deactivate'](),this[_0x238fcc(0x1f8)][_0x238fcc(0x21a)]());}}break;};},Window_PartyActive[_0x43c6f3(0x2bb)]['drawItemImageFace']=function(_0x1fe377){const _0x5e00bc=_0x43c6f3,_0x20584d=this['actor'](_0x1fe377),_0x19da90=this[_0x5e00bc(0x341)](_0x1fe377),_0x343312=Math[_0x5e00bc(0x258)](ImageManager['faceWidth'],_0x19da90['width']-0x2),_0x5e62eb=_0x19da90['height']-0x2;this[_0x5e00bc(0x312)](_0x20584d[_0x5e00bc(0x30f)]());const _0x3240bc=Math[_0x5e00bc(0x31e)](_0x19da90['x']+(_0x19da90[_0x5e00bc(0x235)]-_0x343312)/0x2);this[_0x5e00bc(0x2d6)](_0x20584d,_0x3240bc,_0x19da90['y']+0x1,_0x343312,_0x5e62eb),this[_0x5e00bc(0x312)](!![]);},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x3aa)]=function(_0x4192f3){const _0x2b8e0b=_0x43c6f3,_0x9be66d=this[_0x2b8e0b(0x372)](_0x4192f3),_0x1c3539=this[_0x2b8e0b(0x341)](_0x4192f3),_0x2b461f=VisuMZ[_0x2b8e0b(0x36a)]['Settings'][_0x2b8e0b(0x3e6)],_0x5e07ed=_0x1c3539['x']+Math[_0x2b8e0b(0x31e)](_0x1c3539['width']/0x2)+_0x2b461f[_0x2b8e0b(0x2cb)],_0x9a9075=_0x1c3539['y']+_0x1c3539[_0x2b8e0b(0x3bc)]-this['lineHeight']()-_0x2b461f[_0x2b8e0b(0x2e4)];this[_0x2b8e0b(0x266)](_0x9be66d,_0x5e07ed,_0x9a9075);},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x40d)]=function(_0x8bb59){const _0xa5ec9e=_0x43c6f3,_0x5bffa2=this['actor'](_0x8bb59),_0x2ca48d=_0x5bffa2[_0xa5ec9e(0x386)](),_0xa61af8=this[_0xa5ec9e(0x341)](_0x8bb59),_0x4ce86e=VisuMZ[_0xa5ec9e(0x36a)]['Settings'][_0xa5ec9e(0x3e6)],_0x486159=_0xa61af8['x']+Math[_0xa5ec9e(0x31e)](_0xa61af8[_0xa5ec9e(0x235)]/0x2)+_0x4ce86e[_0xa5ec9e(0x27b)],_0x157728=_0xa61af8['y']+_0xa61af8[_0xa5ec9e(0x3bc)]-this['lineHeight']()-_0x4ce86e[_0xa5ec9e(0x2af)];this[_0xa5ec9e(0x278)](_0x2ca48d,_0x486159,_0x157728);},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x346)]=function(_0x1371b1,_0x457f8f,_0xe4d7e9,_0x566c99){const _0x1f86fb=_0x43c6f3,_0x43aaad=ColorManager[_0x1f86fb(0x264)](),_0x27d759=ColorManager['dimColor2'](),_0xd06fa3=_0xe4d7e9/0x2,_0x2e81e9=this['lineHeight']();while(_0x566c99--){this[_0x1f86fb(0x20c)]['gradientFillRect'](_0x1371b1,_0x457f8f,_0xd06fa3,_0x2e81e9,_0x27d759,_0x43aaad),this['contents'][_0x1f86fb(0x2c3)](_0x1371b1+_0xd06fa3,_0x457f8f,_0xd06fa3,_0x2e81e9,_0x43aaad,_0x27d759);}},Window_PartyActive[_0x43c6f3(0x2bb)]['drawActorName']=function(_0x16ef06,_0x19248f,_0x367826,_0x8bdc05){const _0x3933c7=_0x43c6f3;_0x8bdc05=_0x8bdc05||0xa8,this[_0x3933c7(0x3be)](ColorManager[_0x3933c7(0x2fe)](_0x16ef06)),this['drawText'](_0x16ef06[_0x3933c7(0x38d)](),_0x19248f,_0x367826,_0x8bdc05,_0x3933c7(0x417));},Window_PartyActive['prototype'][_0x43c6f3(0x3f4)]=function(_0xd52174){const _0x59c762=_0x43c6f3;this[_0x59c762(0x22b)]=_0xd52174,this[_0x59c762(0x32d)]();},Window_PartyActive[_0x43c6f3(0x2bb)][_0x43c6f3(0x32d)]=function(){const _0xb58ba6=_0x43c6f3;if(this[_0xb58ba6(0x22b)])this[_0xb58ba6(0x22b)][_0xb58ba6(0x331)](this[_0xb58ba6(0x372)](this[_0xb58ba6(0x328)]()));};function Window_PartyReserve(){this['initialize'](...arguments);}Window_PartyReserve[_0x43c6f3(0x2bb)]=Object[_0x43c6f3(0x401)](Window_StatusBase['prototype']),Window_PartyReserve['prototype']['constructor']=Window_PartyReserve,Window_PartyReserve['_actorGraphic']=VisuMZ[_0x43c6f3(0x36a)]['Settings'][_0x43c6f3(0x3e6)][_0x43c6f3(0x41a)],Window_PartyReserve[_0x43c6f3(0x36d)]=VisuMZ['PartySystem'][_0x43c6f3(0x3f9)]['Window']['ReserveItemThickness'],Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x288)]=function(_0x2da9a9){const _0x534b5f=_0x43c6f3;Window_StatusBase[_0x534b5f(0x2bb)]['initialize'][_0x534b5f(0x3c9)](this,_0x2da9a9),this[_0x534b5f(0x2b9)]=0x0,this['refresh']();},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x3d8)]=function(){const _0x36bb2b=_0x43c6f3;return VisuMZ[_0x36bb2b(0x36a)][_0x36bb2b(0x3f9)]['Window'][_0x36bb2b(0x209)]||0x1;},Window_PartyReserve['prototype'][_0x43c6f3(0x34a)]=function(){const _0x119ed4=_0x43c6f3;return this['lineHeight']()*Window_PartyReserve[_0x119ed4(0x36d)]+0x6;},Window_PartyReserve[_0x43c6f3(0x2bb)]['addRemoveCommand']=function(){const _0x28901d=_0x43c6f3;return VisuMZ[_0x28901d(0x36a)][_0x28901d(0x3f9)][_0x28901d(0x327)][_0x28901d(0x2d2)];},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x335)]=function(){const _0x3d5881=_0x43c6f3;let _0x36a1bb=$gameParty[_0x3d5881(0x3e3)]()[_0x3d5881(0x29d)];if(this[_0x3d5881(0x29c)]())_0x36a1bb++;return _0x36a1bb;},Window_PartyReserve['prototype'][_0x43c6f3(0x372)]=function(_0x5936a9){const _0x231586=_0x43c6f3;return $gameParty[_0x231586(0x3e3)]()[_0x5936a9];},Window_PartyReserve['prototype'][_0x43c6f3(0x1fc)]=function(){const _0x154167=_0x43c6f3;return this[_0x154167(0x372)](this[_0x154167(0x328)]());},Window_PartyReserve['prototype'][_0x43c6f3(0x252)]=function(){SoundManager['playEquip']();},Window_PartyReserve[_0x43c6f3(0x2bb)]['isCurrentItemEnabled']=function(){const _0x258f1d=_0x43c6f3,_0x3613b9=this[_0x258f1d(0x372)](this[_0x258f1d(0x328)]());return _0x3613b9?_0x3613b9[_0x258f1d(0x30f)]():!![];},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x3bf)]=function(){const _0x4ed546=_0x43c6f3;Window_StatusBase[_0x4ed546(0x2bb)][_0x4ed546(0x3bf)][_0x4ed546(0x3c9)](this),this[_0x4ed546(0x302)]();},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x25e)]=function(_0xc91ea){const _0xa7e879=_0x43c6f3;this[_0xa7e879(0x328)]()<=0x0?_0xa7e879(0x355)==='LOOHh'?(this['_partyMemberSwitchWindow']['deactivate'](),this[_0xa7e879(0x1f8)][_0xa7e879(0x21a)](),this[_0xa7e879(0x1f8)]['refresh']()):this['processCancel']():Window_StatusBase[_0xa7e879(0x2bb)][_0xa7e879(0x25e)][_0xa7e879(0x3c9)](this,_0xc91ea);},Window_PartyReserve['prototype']['cursorPagedown']=function(){const _0x19f9f0=_0x43c6f3,_0xb119ca=this[_0x19f9f0(0x328)](),_0x28beea=_0xb119ca+0x1>=this[_0x19f9f0(0x335)]()-0x1?0x0:_0xb119ca+0x1;this[_0x19f9f0(0x31c)](_0xb119ca,_0x28beea);},Window_PartyReserve['prototype'][_0x43c6f3(0x29a)]=function(){const _0x26aa04=_0x43c6f3,_0x358801=this[_0x26aa04(0x328)](),_0x1e5657=_0x358801-0x1<0x0?this[_0x26aa04(0x335)]()-0x2:_0x358801-0x1;this[_0x26aa04(0x31c)](_0x358801,_0x1e5657);},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x31c)]=function(_0x3a7a27,_0x1f9571){const _0x33096b=_0x43c6f3,_0x1bcb75=this[_0x33096b(0x372)](_0x3a7a27),_0xe70639=this['actor'](_0x1f9571);if(!_0x1bcb75?.[_0x33096b(0x30f)]()||!_0xe70639?.[_0x33096b(0x30f)]()){if(_0x33096b(0x2da)==='kKGgZ'){const _0x109b6d=this[_0x33096b(0x328)](),_0x785a51=_0x109b6d+0x1>=this['maxItems']()-0x1?0x0:_0x109b6d+0x1;this['quickSwap'](_0x109b6d,_0x785a51);}else return;}else{if(!_0x1bcb75||!_0xe70639)return;}const _0x40a9b1=$gameParty[_0x33096b(0x22f)],_0xbd2b65=_0x40a9b1[_0x33096b(0x285)](_0x1bcb75[_0x33096b(0x24a)]()),_0x31ff73=_0x40a9b1[_0x33096b(0x285)](_0xe70639['actorId']());_0x40a9b1[_0xbd2b65]=_0xe70639?_0xe70639[_0x33096b(0x24a)]():0x0,_0x40a9b1[_0x31ff73]=_0x1bcb75?_0x1bcb75[_0x33096b(0x24a)]():0x0,this[_0x33096b(0x253)](),this[_0x33096b(0x388)](),this['smoothSelect'](_0x1f9571);},Window_PartyReserve['prototype'][_0x43c6f3(0x302)]=function(){const _0x4aa3a7=_0x43c6f3;if(!this['isShiftShortcutEnabled']())return;Input[_0x4aa3a7(0x363)]('shift')&&(_0x4aa3a7(0x3d3)==='VzPNe'?(_0x28b956(_0x4aa3a7(0x286)[_0x4aa3a7(0x343)](_0x3fdbc3,_0x2107fd)),_0x1a83a2[_0x4aa3a7(0x3b6)]()):this[_0x4aa3a7(0x3a8)]());},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x3a8)]=function(){const _0x451f7a=_0x43c6f3;SoundManager[_0x451f7a(0x250)](),$gameParty[_0x451f7a(0x24b)](),this['smoothSelect'](0x0),SceneManager[_0x451f7a(0x2b4)][_0x451f7a(0x3f6)]();},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x30e)]=function(){const _0xdac8a7=_0x43c6f3;return this[_0xdac8a7(0x34b)];},Window_PartyReserve['prototype']['pendingIndex']=function(){const _0x5777dd=_0x43c6f3,_0x134289=this[_0x5777dd(0x1fc)]();return _0x134289?_0x134289[_0x5777dd(0x328)]():-0x1;},Window_PartyReserve['prototype'][_0x43c6f3(0x25d)]=function(_0x5c163e){const _0x207fcf=_0x43c6f3;Window_StatusBase['prototype'][_0x207fcf(0x25d)]['call'](this,_0x5c163e);if(_0x5c163e>=0x0)this[_0x207fcf(0x2b9)]=_0x5c163e;},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x2a8)]=function(){const _0x55ee68=_0x43c6f3;this[_0x55ee68(0x2b9)]=Math[_0x55ee68(0x258)](this['_lastIndex'],this[_0x55ee68(0x335)]()-0x1),this[_0x55ee68(0x202)](this[_0x55ee68(0x2b9)]),this[_0x55ee68(0x1f9)](!![]),this[_0x55ee68(0x3bb)]=!![];},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x274)]=function(_0x29ab98){const _0x474937=_0x43c6f3,_0xbf1a5f=this[_0x474937(0x372)](_0x29ab98);if(!_0xbf1a5f)return this['drawRemoveCommand'](_0x29ab98);const _0x54b3d2=this[_0x474937(0x249)](_0x29ab98);this[_0x474937(0x370)](_0x29ab98);const _0x21d98e=0xa8,_0x56e197=Window_PartyReserve[_0x474937(0x36d)]===0x1,_0x2934ae=ImageManager['iconWidth']*(_0x56e197?0x2:0x1),_0x16beae=this[_0x474937(0x24c)]()+this['itemPadding'](),_0x595361=_0x54b3d2[_0x474937(0x235)]-_0x21d98e,_0x3eb8eb=_0x54b3d2['x']+_0x2934ae+Math['min'](_0x16beae,_0x595361),_0x2f2936=_0x56e197?![]:!![];this[_0x474937(0x312)](_0xbf1a5f['isFormationChangeOk']()),this[_0x474937(0x2ed)](_0xbf1a5f,_0x54b3d2['x'],_0x54b3d2['y'],_0x2f2936),this['drawActorName'](_0xbf1a5f,_0x3eb8eb,_0x54b3d2['y'],_0x21d98e),this[_0x474937(0x312)](!![]);},Window_PartyReserve['prototype'][_0x43c6f3(0x24c)]=function(){const _0x55ac42=_0x43c6f3,_0x12d2cb=VisuMZ['PartySystem'][_0x55ac42(0x3f9)][_0x55ac42(0x3e6)];switch(Window_PartyReserve['_actorGraphic'][_0x55ac42(0x3c8)]()[_0x55ac42(0x248)]()){case _0x55ac42(0x2c4):return ImageManager[_0x55ac42(0x223)];case _0x55ac42(0x239):return _0x12d2cb[_0x55ac42(0x2f7)]*0x2;case _0x55ac42(0x3b5):return _0x12d2cb[_0x55ac42(0x3df)]*0x2;};},Window_PartyReserve['prototype'][_0x43c6f3(0x259)]=function(_0x506fab){const _0x3a1c12=_0x43c6f3,_0x5b8a2d=this[_0x3a1c12(0x249)](_0x506fab);this['changePaintOpacity'](!![]);const _0x10d1b5=TextManager[_0x3a1c12(0x3b2)];this[_0x3a1c12(0x375)](_0x10d1b5,_0x5b8a2d['x'],_0x5b8a2d['y'],_0x5b8a2d[_0x3a1c12(0x235)],_0x3a1c12(0x417));},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x370)]=function(_0x420b9a){const _0x1c8132=_0x43c6f3;switch(Window_PartyReserve[_0x1c8132(0x402)]['toLowerCase']()['trim']()){case _0x1c8132(0x2c4):this[_0x1c8132(0x37f)](_0x420b9a);break;case'sprite':this['drawItemImageSprite'](_0x420b9a);break;case _0x1c8132(0x3b5):Imported[_0x1c8132(0x2d9)]&&this[_0x1c8132(0x40d)](_0x420b9a);break;};},Window_PartyReserve[_0x43c6f3(0x2bb)]['drawItemImageFace']=function(_0x17f78e){const _0x163e2e=_0x43c6f3,_0x33657e=this[_0x163e2e(0x372)](_0x17f78e),_0x535a88=this[_0x163e2e(0x341)](_0x17f78e),_0x139b97=Window_PartyReserve[_0x163e2e(0x36d)]===0x1;_0x535a88['x']+=ImageManager[_0x163e2e(0x299)]*(_0x139b97?0x2:0x1);const _0x3d3ab7=ImageManager[_0x163e2e(0x223)],_0x2e0137=_0x535a88[_0x163e2e(0x3bc)]-0x2;this[_0x163e2e(0x312)](_0x33657e[_0x163e2e(0x30f)]()),this[_0x163e2e(0x2d6)](_0x33657e,_0x535a88['x']+0x1,_0x535a88['y']+0x1,_0x3d3ab7,_0x2e0137),this['changePaintOpacity'](!![]);},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x3aa)]=function(_0xd183d7){const _0xe3c68e=_0x43c6f3,_0x421c12=this[_0xe3c68e(0x372)](_0xd183d7),_0x531d1e=this[_0xe3c68e(0x341)](_0xd183d7),_0x12039e=Window_PartyReserve['_rowThickness']===0x1;_0x531d1e['x']+=ImageManager[_0xe3c68e(0x299)]*(_0x12039e?0x2:0x1);const _0x545588=VisuMZ[_0xe3c68e(0x36a)][_0xe3c68e(0x3f9)]['Window'],_0x29c184=_0x531d1e['x']+_0x545588['ReserveSpriteOffsetX']+this[_0xe3c68e(0x411)](),_0x319672=_0x531d1e['y']+_0x531d1e[_0xe3c68e(0x3bc)]-_0x545588[_0xe3c68e(0x354)];this[_0xe3c68e(0x266)](_0x421c12,_0x29c184,_0x319672);},Window_PartyReserve['prototype']['drawItemImageSvActor']=function(_0x58076d){const _0x10f267=_0x43c6f3,_0x5537e7=this[_0x10f267(0x372)](_0x58076d),_0xcb5387=_0x5537e7[_0x10f267(0x386)](),_0x2d9d6a=this[_0x10f267(0x341)](_0x58076d),_0x58b5f5=Window_PartyReserve[_0x10f267(0x36d)]===0x1;_0x2d9d6a['x']+=ImageManager['iconWidth']*(_0x58b5f5?0x2:0x1);const _0x200b71=VisuMZ[_0x10f267(0x36a)][_0x10f267(0x3f9)][_0x10f267(0x3e6)],_0x3c89cc=_0x2d9d6a['x']+_0x200b71[_0x10f267(0x3df)]+this[_0x10f267(0x411)](),_0x3f678d=_0x2d9d6a['y']+_0x2d9d6a[_0x10f267(0x3bc)]-_0x200b71['ReserveBattlerOffsetY'];this[_0x10f267(0x278)](_0xcb5387,_0x3c89cc,_0x3f678d);},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x3f4)]=function(_0x202f4){const _0x514b10=_0x43c6f3;this[_0x514b10(0x22b)]=_0x202f4,this[_0x514b10(0x32d)]();},Window_PartyReserve[_0x43c6f3(0x2bb)][_0x43c6f3(0x32d)]=function(){const _0x175f78=_0x43c6f3;this[_0x175f78(0x22b)]&&(_0x175f78(0x3fe)!=='VzIzK'?this[_0x175f78(0x22b)]['setActor'](this[_0x175f78(0x372)](this['index']())):_0x457166[_0x175f78(0x2c9)]());};function Window_PartyStatus(){const _0xd04edc=_0x43c6f3;this[_0xd04edc(0x288)](...arguments);}Window_PartyStatus[_0x43c6f3(0x2bb)]=Object['create'](Window_StatusBase[_0x43c6f3(0x2bb)]),Window_PartyStatus[_0x43c6f3(0x2bb)]['constructor']=Window_PartyStatus,Window_PartyStatus[_0x43c6f3(0x2bb)][_0x43c6f3(0x288)]=function(_0x280967){const _0x258dcd=_0x43c6f3;this[_0x258dcd(0x308)]=null,Window_StatusBase[_0x258dcd(0x2bb)]['initialize'][_0x258dcd(0x3c9)](this,_0x280967);},Window_PartyStatus[_0x43c6f3(0x2bb)]['drawItemDarkRect']=function(_0x4ae453,_0x472208,_0x373332,_0x34830f,_0x363954){const _0x4a17d6=_0x43c6f3;if(VisuMZ['PartySystem'][_0x4a17d6(0x3f9)]['General'][_0x4a17d6(0x3dd)]===![])return;_0x363954=Math[_0x4a17d6(0x33f)](_0x363954||0x1,0x1);while(_0x363954--){_0x34830f=_0x34830f||this[_0x4a17d6(0x2ca)](),this[_0x4a17d6(0x20c)][_0x4a17d6(0x3b0)]=0xa0;const _0xbb8142=ColorManager[_0x4a17d6(0x3de)]();this[_0x4a17d6(0x20c)][_0x4a17d6(0x3ab)](_0x4ae453+0x1,_0x472208+0x1,_0x373332-0x2,_0x34830f-0x2,_0xbb8142),this['contents'][_0x4a17d6(0x3b0)]=0xff;}},ColorManager[_0x43c6f3(0x3de)]=function(){const _0x3bd4b8=_0x43c6f3,_0x2bcaa2=VisuMZ[_0x3bd4b8(0x36a)][_0x3bd4b8(0x3f9)][_0x3bd4b8(0x327)];let _0x5d397f=_0x2bcaa2[_0x3bd4b8(0x1f2)]!==undefined?_0x2bcaa2[_0x3bd4b8(0x1f2)]:0x13;return ColorManager[_0x3bd4b8(0x228)](_0x5d397f);},Window_PartyStatus[_0x43c6f3(0x2bb)][_0x43c6f3(0x331)]=function(_0xc0410a){const _0x156648=_0x43c6f3;if(this['_actor']===_0xc0410a)return;this['_actor']=_0xc0410a;if(_0xc0410a){const _0x194ded=ImageManager[_0x156648(0x35a)](_0xc0410a[_0x156648(0x3d2)]());_0x194ded[_0x156648(0x2d4)](this[_0x156648(0x253)][_0x156648(0x1e9)](this));}else this['refresh']();},Window_PartyStatus[_0x43c6f3(0x2bb)]['refresh']=function(){const _0x17f7d3=_0x43c6f3;Window_StatusBase[_0x17f7d3(0x2bb)][_0x17f7d3(0x253)][_0x17f7d3(0x3c9)](this),this[_0x17f7d3(0x20c)][_0x17f7d3(0x206)](),this['resetFontSettings'](),VisuMZ[_0x17f7d3(0x36a)][_0x17f7d3(0x3f9)][_0x17f7d3(0x3e6)][_0x17f7d3(0x242)][_0x17f7d3(0x3c9)](this);},Window_PartyStatus[_0x43c6f3(0x2bb)][_0x43c6f3(0x22c)]=function(){const _0x385945=_0x43c6f3;if(!this[_0x385945(0x308)]){this[_0x385945(0x349)](0x0,0x0,this[_0x385945(0x21b)],this['innerHeight']);const _0x459b47=Math[_0x385945(0x31e)]((this[_0x385945(0x27a)]-this['lineHeight']())/0x2);this[_0x385945(0x3be)](ColorManager[_0x385945(0x391)]()),this[_0x385945(0x375)](TextManager[_0x385945(0x329)],0x0,_0x459b47,this[_0x385945(0x21b)],_0x385945(0x417));return;}this[_0x385945(0x2d6)](this[_0x385945(0x308)],0x1,0x0,ImageManager[_0x385945(0x223)],ImageManager[_0x385945(0x243)]),this['drawActorSimpleStatus'](this[_0x385945(0x308)],ImageManager[_0x385945(0x223)]+0x24,0x0);const _0x290f28=this['lineHeight'](),_0x2db682=this[_0x385945(0x333)](),_0xd31739=Math[_0x385945(0x31e)](this['innerWidth']/0x2),_0xd1b573=Math[_0x385945(0x287)](_0x2db682['length']/0x2)*_0x290f28,_0x30ffd7=0x0;let _0x2d39ac=0x0,_0x25d2ab=ImageManager[_0x385945(0x243)]+_0x290f28/0x2;for(const _0x212575 of _0x2db682){this[_0x385945(0x349)](_0x2d39ac,_0x25d2ab,_0xd31739,_0x290f28),this[_0x385945(0x330)](_0x212575,_0x2d39ac,_0x25d2ab,_0xd31739),this[_0x385945(0x20d)](_0x212575,_0x2d39ac,_0x25d2ab,_0xd31739);if(_0x2d39ac===_0x30ffd7){if(_0x385945(0x371)!=='sFggd')return _0x5aa799[_0x385945(0x3a7)];else _0x2d39ac+=_0xd31739;}else _0x385945(0x318)!=='QSHER'?(_0x2d39ac=_0x30ffd7,_0x25d2ab+=_0x290f28):this[_0x385945(0x40a)]()&&this['processOk']();}},Window_PartyStatus['prototype'][_0x43c6f3(0x333)]=function(){const _0x2fbb64=_0x43c6f3;if(Imported[_0x2fbb64(0x38f)])return VisuMZ[_0x2fbb64(0x2e5)][_0x2fbb64(0x3f9)][_0x2fbb64(0x310)]['DisplayedParams'];else{if('skwOM'!==_0x2fbb64(0x26f))_0x4fd669[_0x2fbb64(0x2bb)][_0x2fbb64(0x401)][_0x2fbb64(0x3c9)](this),this['createActivePartyLabel'](),this[_0x2fbb64(0x39c)](),this[_0x2fbb64(0x3f5)](),this[_0x2fbb64(0x410)](),this[_0x2fbb64(0x2f8)](),this[_0x2fbb64(0x237)]();else return[0x2,0x3,0x4,0x5,0x6,0x7];}},Window_PartyStatus[_0x43c6f3(0x2bb)][_0x43c6f3(0x330)]=function(_0x4db033,_0x295b39,_0x3ab591,_0x431ac6){const _0x1923a4=_0x43c6f3,_0x3fde19=this['itemPadding']();_0x431ac6-=_0x3fde19*0x2;if(Imported[_0x1923a4(0x38f)]){if(_0x1923a4(0x3b4)===_0x1923a4(0x3b4))this[_0x1923a4(0x1ea)](_0x295b39+_0x3fde19,_0x3ab591,_0x431ac6,_0x4db033,![]);else{const _0x2fa845=_0x3d5c42[_0x1923a4(0x372)](),_0x1cd322=_0x2fa845['battler']();this['_partyMemberSwitchWindow'][_0x1923a4(0x39f)](),this[_0x1923a4(0x213)]()&&_0x1cd322?(this[_0x1923a4(0x3b8)]=!![],_0x1cd322['startSwitchOutAnimation'](_0x470119)):this[_0x1923a4(0x3a0)](_0x5b8998);}}else{const _0x4c7f34=TextManager[_0x1923a4(0x2a3)](_0x4db033);this['changeTextColor'](ColorManager[_0x1923a4(0x391)]()),this[_0x1923a4(0x375)](_0x4c7f34,_0x295b39+_0x3fde19,_0x3ab591,_0x431ac6);}},Window_PartyStatus[_0x43c6f3(0x2bb)][_0x43c6f3(0x20d)]=function(_0x514fd6,_0x207c22,_0x773bc1,_0x5c8e6e){const _0xe58603=_0x43c6f3;this[_0xe58603(0x271)]();const _0x6c9a93=this[_0xe58603(0x411)](),_0x3d98e2=this['getParamValue'](_0x514fd6);this[_0xe58603(0x375)](_0x3d98e2,_0x207c22+_0x6c9a93,_0x773bc1,_0x5c8e6e-_0x6c9a93*0x2,_0xe58603(0x240));},Window_PartyStatus['prototype'][_0x43c6f3(0x2cf)]=function(_0x298bf3){const _0x14724c=_0x43c6f3,_0x126cdc=this[_0x14724c(0x308)];if(Imported[_0x14724c(0x38f)])return _0x126cdc[_0x14724c(0x246)](_0x298bf3,!![]);else{if(_0x14724c(0x2ff)===_0x14724c(0x2ff))return _0x126cdc[_0x14724c(0x2a3)](_0x298bf3);else _0x49fedb[_0x14724c(0x210)](_0x14724c(0x387)),_0x3379c0[_0x14724c(0x394)]=!![];}};function Window_PartyBattleSwitch(){const _0x4257db=_0x43c6f3;this[_0x4257db(0x288)](...arguments);}Window_PartyBattleSwitch[_0x43c6f3(0x2bb)]=Object[_0x43c6f3(0x401)](Window_StatusBase['prototype']),Window_PartyBattleSwitch[_0x43c6f3(0x2bb)][_0x43c6f3(0x226)]=Window_PartyBattleSwitch,Window_PartyBattleSwitch[_0x43c6f3(0x2bb)][_0x43c6f3(0x288)]=function(_0x53a5e){const _0x15ce5c=_0x43c6f3;Window_StatusBase[_0x15ce5c(0x2bb)][_0x15ce5c(0x288)][_0x15ce5c(0x3c9)](this,_0x53a5e),this[_0x15ce5c(0x3b7)](VisuMZ['PartySystem'][_0x15ce5c(0x3f9)]['Window'][_0x15ce5c(0x2a5)]),this[_0x15ce5c(0x270)]=0x0;},Window_PartyBattleSwitch[_0x43c6f3(0x2bb)]['loadFaceImages']=function(){const _0x55a6bf=_0x43c6f3;for(const _0x553112 of $gameParty['allMembers']()){'QoAaC'!==_0x55a6bf(0x374)?ImageManager[_0x55a6bf(0x35a)](_0x553112['faceName']()):(_0x104e73[_0x55a6bf(0x2bb)]['deactivate']['call'](this),this[_0x55a6bf(0x216)]());}},Window_PartyBattleSwitch[_0x43c6f3(0x2bb)]['maxCols']=function(){return 0x1;},Window_PartyBattleSwitch[_0x43c6f3(0x2bb)][_0x43c6f3(0x372)]=function(_0x239f70){const _0x10eca0=_0x43c6f3;return $gameParty[_0x10eca0(0x3e3)]()[_0x239f70];},Window_PartyBattleSwitch['prototype']['currentActor']=function(){const _0x3e65b0=_0x43c6f3;return this[_0x3e65b0(0x372)](this['index']());},Window_PartyBattleSwitch['prototype'][_0x43c6f3(0x34a)]=function(){const _0x546b7a=_0x43c6f3;return this[_0x546b7a(0x2ca)]()*0x2+0x8;},Window_PartyBattleSwitch[_0x43c6f3(0x2bb)][_0x43c6f3(0x335)]=function(){const _0x168ce6=_0x43c6f3;return $gameParty['reserveMembers']()[_0x168ce6(0x29d)];},Window_PartyBattleSwitch[_0x43c6f3(0x2bb)][_0x43c6f3(0x21a)]=function(){const _0x4b2a7a=_0x43c6f3;Window_StatusBase[_0x4b2a7a(0x2bb)][_0x4b2a7a(0x21a)][_0x4b2a7a(0x3c9)](this),this[_0x4b2a7a(0x26a)](),this[_0x4b2a7a(0x253)](),this[_0x4b2a7a(0x202)](0x0);},Window_PartyBattleSwitch[_0x43c6f3(0x2bb)][_0x43c6f3(0x39f)]=function(){const _0x28a3ba=_0x43c6f3;Window_StatusBase['prototype'][_0x28a3ba(0x39f)][_0x28a3ba(0x3c9)](this),this[_0x28a3ba(0x216)]();},Window_PartyBattleSwitch['prototype']['isCurrentItemEnabled']=function(){const _0x12b87=_0x43c6f3;return this[_0x12b87(0x3d4)](this['currentActor']());},Window_PartyBattleSwitch[_0x43c6f3(0x2bb)]['isEnabled']=function(_0xd22cf0){const _0x57acff=_0x43c6f3;if(!_0xd22cf0)return![];return _0xd22cf0['isFormationChangeOk']()&&_0xd22cf0[_0x57acff(0x224)]();},Window_PartyBattleSwitch[_0x43c6f3(0x2bb)][_0x43c6f3(0x274)]=function(_0x6d43d7){const _0xcddbb9=_0x43c6f3,_0x51b6ef=this[_0xcddbb9(0x372)](_0x6d43d7);if(!_0x51b6ef)return;const _0x5e045d=ImageManager[_0xcddbb9(0x35a)](_0x51b6ef[_0xcddbb9(0x3d2)]());_0x5e045d[_0xcddbb9(0x2d4)](this[_0xcddbb9(0x2ad)][_0xcddbb9(0x1e9)](this,_0x6d43d7));},Window_PartyBattleSwitch[_0x43c6f3(0x2bb)]['processDrawItem']=function(_0x2ea822){const _0xd68374=_0x43c6f3;this[_0xd68374(0x370)](_0x2ea822),this[_0xd68374(0x33d)](_0x2ea822);},Window_PartyBattleSwitch['prototype'][_0x43c6f3(0x370)]=function(_0x3424ef){const _0xe3aa9f=_0x43c6f3,_0x1f8927=this[_0xe3aa9f(0x372)](_0x3424ef),_0x2e4f83=this[_0xe3aa9f(0x341)](_0x3424ef);this[_0xe3aa9f(0x312)](this[_0xe3aa9f(0x3d4)](_0x1f8927)),this[_0xe3aa9f(0x2d6)](_0x1f8927,_0x2e4f83['x']+0x1,_0x2e4f83['y']+0x1,ImageManager[_0xe3aa9f(0x223)],_0x2e4f83['height']-0x2),this['changePaintOpacity'](!![]);},Window_PartyBattleSwitch[_0x43c6f3(0x2bb)][_0x43c6f3(0x33d)]=function(_0x12bc02){const _0x5037b5=_0x43c6f3,_0x3af8ff=this[_0x5037b5(0x372)](_0x12bc02),_0x2f050b=this[_0x5037b5(0x33b)](_0x12bc02),_0x567b57=_0x2f050b['x']+ImageManager[_0x5037b5(0x223)]+0x24,_0x3acdef=_0x567b57+0xb4;this[_0x5037b5(0x312)](this[_0x5037b5(0x3d4)](_0x3af8ff)),this['drawActorName'](_0x3af8ff,_0x567b57,_0x2f050b['y']),this[_0x5037b5(0x277)](_0x3af8ff,_0x567b57,_0x2f050b['y']+this[_0x5037b5(0x2ca)]()),this[_0x5037b5(0x35e)](_0x3af8ff,_0x3acdef,_0x2f050b['y']),this[_0x5037b5(0x312)](!![]);};Imported[_0x43c6f3(0x38a)]&&(ImageManager['battlePartyChangeIcon']=VisuMZ['PartySystem']['Settings'][_0x43c6f3(0x327)]['BattlePartyIcon']??0x4b,TextManager['battlePartyChangeCmd']=VisuMZ[_0x43c6f3(0x36a)]['Settings'][_0x43c6f3(0x3cc)][_0x43c6f3(0x3d9)],TextManager[_0x43c6f3(0x2ba)]=VisuMZ['PartySystem'][_0x43c6f3(0x3f9)][_0x43c6f3(0x3cc)][_0x43c6f3(0x3f7)],TextManager[_0x43c6f3(0x3cf)]=VisuMZ[_0x43c6f3(0x36a)]['Settings'][_0x43c6f3(0x3cc)][_0x43c6f3(0x27e)],TextManager['battlePartySwitchCmdHelp']=VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3f9)]['Vocab'][_0x43c6f3(0x412)],TextManager['ActiveTpbFormationMessage']=VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3f9)][_0x43c6f3(0x3cc)][_0x43c6f3(0x405)],VisuMZ['PartySystem']['SceneManager_isPreviousSceneBattleTransitionable']=SceneManager[_0x43c6f3(0x2dc)],SceneManager['isPreviousSceneBattleTransitionable']=function(){const _0x54cd6=_0x43c6f3;if(SceneManager[_0x54cd6(0x3f1)](Scene_Party))return!![];return VisuMZ[_0x54cd6(0x36a)][_0x54cd6(0x1f5)][_0x54cd6(0x3c9)](this);},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3d0)]=SceneManager['isNextSceneBattleTransitionable'],SceneManager['isNextSceneBattleTransitionable']=function(){const _0x46431b=_0x43c6f3;if(SceneManager[_0x46431b(0x2c7)](Scene_Party))return!![];return VisuMZ[_0x46431b(0x36a)][_0x46431b(0x3d0)]['call'](this);},SceneManager[_0x43c6f3(0x39d)]=function(){const _0x4bdd50=_0x43c6f3;return this['_scene']&&this['_scene'][_0x4bdd50(0x226)]===Scene_Map;},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x366)]=Scene_Battle['prototype']['createAllWindows'],Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x378)]=function(){const _0x21d410=_0x43c6f3;VisuMZ[_0x21d410(0x36a)][_0x21d410(0x366)][_0x21d410(0x3c9)](this),this[_0x21d410(0x30d)](),this['postPartySwitchMenuTpb'](),this[_0x21d410(0x275)]();},Scene_Battle['prototype'][_0x43c6f3(0x30d)]=function(){const _0x274f38=_0x43c6f3,_0x41a87c=this['partySwitchWindowRect']();this[_0x274f38(0x2ac)]=new Window_PartyBattleSwitch(_0x41a87c),this[_0x274f38(0x3e0)](this[_0x274f38(0x2ac)]),this[_0x274f38(0x2ac)]['setHandler']('ok',this[_0x274f38(0x37d)][_0x274f38(0x1e9)](this)),this[_0x274f38(0x2ac)][_0x274f38(0x336)](_0x274f38(0x338),this['onPartySwitchCancel'][_0x274f38(0x1e9)](this));},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x218)]=function(){const _0x453e7b=_0x43c6f3,_0x51dce4=this[_0x453e7b(0x307)]();if(_0x51dce4===_0x453e7b(0x3ba)){if(_0x453e7b(0x352)!==_0x453e7b(0x2ab))return this[_0x453e7b(0x2aa)]();else this[_0x453e7b(0x288)](...arguments);}else return this['partySwitchWindowRectStandard']();},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x36c)]=function(){const _0x33c20e=_0x43c6f3;return VisuMZ[_0x33c20e(0x36a)][_0x33c20e(0x3f9)][_0x33c20e(0x3e6)][_0x33c20e(0x31b)][_0x33c20e(0x3c9)](this);},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x2aa)]=function(){const _0x387eb9=_0x43c6f3,_0x3754bf=this[_0x387eb9(0x347)](),_0x1e026b=$gameSystem['windowPadding']()*0x2;return _0x3754bf[_0x387eb9(0x235)]=0x204+_0x1e026b,_0x3754bf;},VisuMZ[_0x43c6f3(0x36a)]['Scene_Battle_isAnyInputWindowActive']=Scene_Battle[_0x43c6f3(0x2bb)]['isAnyInputWindowActive'],Scene_Battle['prototype']['isAnyInputWindowActive']=function(){const _0x56d1c6=_0x43c6f3;if(this[_0x56d1c6(0x2ac)]&&this[_0x56d1c6(0x2ac)][_0x56d1c6(0x34b)])return!![];if(this[_0x56d1c6(0x3b8)])return!![];if(this[_0x56d1c6(0x34f)])return!![];if(this[_0x56d1c6(0x283)])return!![];return VisuMZ['PartySystem'][_0x56d1c6(0x247)][_0x56d1c6(0x3c9)](this);},VisuMZ[_0x43c6f3(0x36a)]['Scene_Battle_createPartyCommandWindowBattleCore']=Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x3cb)],Scene_Battle['prototype'][_0x43c6f3(0x3cb)]=function(){const _0x32ab63=_0x43c6f3;VisuMZ[_0x32ab63(0x36a)][_0x32ab63(0x357)][_0x32ab63(0x3c9)](this),this[_0x32ab63(0x20b)][_0x32ab63(0x336)]('formation',this[_0x32ab63(0x289)][_0x32ab63(0x1e9)](this));},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x289)]=function(){const _0x3c88fb=_0x43c6f3;this[_0x3c88fb(0x32e)]()?(this[_0x3c88fb(0x283)]=!![],this['_logWindow'][_0x3c88fb(0x236)](TextManager['ActiveTpbFormationMessage']['format'](TextManager['formation']))):this['callFormation']();},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x32e)]=function(){const _0x402693=_0x43c6f3;return BattleManager[_0x402693(0x221)]();},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x3db)]=function(){const _0x553f82=_0x43c6f3;this[_0x553f82(0x283)]=![],this[_0x553f82(0x2a4)][_0x553f82(0x3c5)](),this[_0x553f82(0x300)][_0x553f82(0x3ec)]=![],SceneManager[_0x553f82(0x369)](),SceneManager['push'](Scene_Party),$gameParty['applyBattlePartySwitchCooldown'](),BattleManager[_0x553f82(0x2b8)]()&&(BattleManager['_tpbSceneChangeCacheActor']=BattleManager[_0x553f82(0x372)]());},VisuMZ[_0x43c6f3(0x36a)]['Scene_Battle_updateBattleProcess']=Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x392)],Scene_Battle[_0x43c6f3(0x2bb)]['updateBattleProcess']=function(){const _0x2b7403=_0x43c6f3;VisuMZ[_0x2b7403(0x36a)]['Scene_Battle_updateBattleProcess'][_0x2b7403(0x3c9)](this),this[_0x2b7403(0x283)]&&!BattleManager['_subject']&&(_0x2b7403(0x306)!=='IGDGL'?(_0x5b1b7c['PartySystem']['Scene_Battle_createPartyCommandWindowBattleCore'][_0x2b7403(0x3c9)](this),this[_0x2b7403(0x20b)][_0x2b7403(0x336)]('formation',this[_0x2b7403(0x289)][_0x2b7403(0x1e9)](this))):this[_0x2b7403(0x3db)]()),this[_0x2b7403(0x34f)]&&!BattleManager[_0x2b7403(0x313)]&&(_0x2b7403(0x203)===_0x2b7403(0x203)?this[_0x2b7403(0x3eb)]():this['_battleMaxSize']=_0xc69b40[_0x2b7403(0x272)]);},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x362)]=Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x2d3)],Scene_Battle['prototype'][_0x43c6f3(0x2d3)]=function(){const _0x246d65=_0x43c6f3;if(BattleManager['isActiveTpb']()){if(_0x246d65(0x3a5)===_0x246d65(0x3a5)){if(this[_0x246d65(0x2ac)]&&this[_0x246d65(0x2ac)][_0x246d65(0x34b)]){if('Bdpqn'===_0x246d65(0x325)){if(this[_0x246d65(0x2a2)]===_0xb62999)this[_0x246d65(0x22a)]();this[_0x246d65(0x2a2)]--;}else return![];}}else this['index']()<=0x0?this[_0x246d65(0x301)]():_0x248a44[_0x246d65(0x2bb)][_0x246d65(0x25e)][_0x246d65(0x3c9)](this,_0x9e77d4);}return VisuMZ[_0x246d65(0x36a)][_0x246d65(0x362)]['call'](this);},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x32b)]=Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x339)],Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x339)]=function(){const _0x50009e=_0x43c6f3;VisuMZ['PartySystem'][_0x50009e(0x32b)][_0x50009e(0x3c9)](this),this[_0x50009e(0x1f8)][_0x50009e(0x336)](_0x50009e(0x3a2),this[_0x50009e(0x3e5)][_0x50009e(0x1e9)](this));},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x3e5)]=function(){const _0x143ac4=_0x43c6f3;this['isQueueFormationMenu']()?_0x143ac4(0x2e7)===_0x143ac4(0x2e7)?(this['_callPartyMemberSwitch']=!![],this['_logWindow'][_0x143ac4(0x236)](TextManager[_0x143ac4(0x35f)][_0x143ac4(0x343)](TextManager[_0x143ac4(0x3a2)]))):this[_0x143ac4(0x288)](...arguments):this['callPartyMemberSwitch']();},Scene_Battle[_0x43c6f3(0x2bb)]['callPartyMemberSwitch']=function(){const _0x44086d=_0x43c6f3;this[_0x44086d(0x34f)]=![],this[_0x44086d(0x3fd)][_0x44086d(0x206)](),BattleManager[_0x44086d(0x372)]()&&this[_0x44086d(0x2ac)][_0x44086d(0x21a)]();},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x37d)]=function(){const _0x3f5e09=_0x43c6f3,_0x3fad0a=this[_0x3f5e09(0x2ac)][_0x3f5e09(0x1fc)]();if(_0x3fad0a){if('LOXLY'!==_0x3f5e09(0x217))this[_0x3f5e09(0x3f2)](_0x3fad0a);else{const _0x1f0729=_0x37545f['param'](_0x52be46);this[_0x3f5e09(0x3be)](_0x1aa3e1[_0x3f5e09(0x391)]()),this[_0x3f5e09(0x375)](_0x1f0729,_0x1d8d94+_0x4ad42a,_0x4fd2d6,_0x3bf3e4);}}else{if(_0x3f5e09(0x2c2)!==_0x3f5e09(0x2c2)){const _0x325c26=this['battleMembers']();return this[_0x3f5e09(0x1ed)]()[_0x3f5e09(0x298)](_0x37e266=>!_0x325c26['includes'](_0x37e266));}else this[_0x3f5e09(0x2ac)]['deactivate'](),this[_0x3f5e09(0x1f8)][_0x3f5e09(0x21a)]();}},Scene_Battle[_0x43c6f3(0x2bb)]['preparePartySwitchMember']=function(_0x2f23c9){const _0x241a1f=_0x43c6f3,_0x2dc6b5=BattleManager[_0x241a1f(0x372)](),_0x39af11=_0x2dc6b5[_0x241a1f(0x2fb)]();this[_0x241a1f(0x2ac)]['deactivate'](),this[_0x241a1f(0x213)]()&&_0x39af11?'eiQbY'===_0x241a1f(0x304)?(this['_partySystemSwitchOut']=!![],_0x39af11[_0x241a1f(0x38c)](_0x2f23c9)):(_0x3b977d[_0x241a1f(0x36a)][_0x241a1f(0x383)][_0x241a1f(0x3c9)](this),this[_0x241a1f(0x22a)](),this[_0x241a1f(0x2a0)](),this[_0x241a1f(0x3ac)]()):this['processPartySwitchMember'](_0x2f23c9);},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x213)]=function(){const _0x3d1f14=_0x43c6f3;return VisuMZ[_0x3d1f14(0x36a)][_0x3d1f14(0x3f9)][_0x3d1f14(0x327)]['SwitchOutAnimation'];},Scene_Battle[_0x43c6f3(0x2bb)]['processPartySwitchMember']=function(_0x50b14c){const _0x25b916=_0x43c6f3;this[_0x25b916(0x3b8)]=![];const _0x1593e6=BattleManager[_0x25b916(0x372)](),_0x2d5a24=_0x1593e6[_0x25b916(0x2fb)]();$gameParty[_0x25b916(0x34c)][_0x1593e6[_0x25b916(0x328)]()]=_0x50b14c[_0x25b916(0x24a)](),$gameParty['partyChangeRefresh']();if(this['isImmediateTpb']())_0x50b14c['_tpbChargeTime']=_0x1593e6['_tpbChargeTime'],_0x50b14c[_0x25b916(0x356)]='charged';else BattleManager[_0x25b916(0x2b8)]()&&_0x50b14c['clearTpbChargeTime']();BattleManager[_0x25b916(0x245)]=_0x50b14c,_0x50b14c['applyBattlePartySwitchCooldown'](),_0x50b14c['makeActions'](),_0x50b14c[_0x25b916(0x3c1)](_0x1593e6);if(_0x2d5a24){if(_0x25b916(0x364)!==_0x25b916(0x373))_0x2d5a24[_0x25b916(0x2c6)](_0x50b14c);else{if(!this[_0x25b916(0x308)])return![];return _0x506b54[_0x25b916(0x36a)][_0x25b916(0x3f9)][_0x25b916(0x327)]['ActorCmdWinAddParty'];}}this[_0x25b916(0x22b)][_0x25b916(0x2fc)](_0x1593e6,_0x50b14c),this[_0x25b916(0x22b)]['refresh'](),this[_0x25b916(0x1f8)][_0x25b916(0x21e)](_0x50b14c),this['_actorCommandWindow']['smoothSelect'](0x0),this['_actorCommandWindow'][_0x25b916(0x21a)](),this[_0x25b916(0x1f8)][_0x25b916(0x31f)]=!![];},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x23e)]=function(){const _0x44de9c=_0x43c6f3;if(!BattleManager['isTpb']())return![];const _0x2c54ea=VisuMZ['PartySystem']['Settings'][_0x44de9c(0x327)];return _0x2c54ea[_0x44de9c(0x2f9)]===undefined&&(_0x2c54ea[_0x44de9c(0x2f9)]=!![]),_0x2c54ea[_0x44de9c(0x2f9)];},Window_StatusBase[_0x43c6f3(0x2bb)][_0x43c6f3(0x2fc)]=function(_0x5e5f82,_0x265fbb){const _0x43e89b=_0x43c6f3,_0x2176d9=_0x43e89b(0x3c3)[_0x43e89b(0x343)](_0x5e5f82['actorId']()),_0x3c9293=this['createInnerSprite'](_0x2176d9,Sprite_StateIcon);_0x3c9293[_0x43e89b(0x21e)](_0x265fbb);},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x1f0)]=function(){const _0x2e5a76=_0x43c6f3;this[_0x2e5a76(0x2ac)]['deactivate'](),this[_0x2e5a76(0x1f8)][_0x2e5a76(0x21a)](),this[_0x2e5a76(0x1f8)][_0x2e5a76(0x253)]();},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x35d)]=function(){const _0x477225=_0x43c6f3;if(!BattleManager[_0x477225(0x2b8)]())return;if(!SceneManager[_0x477225(0x3f1)](Scene_Party))return;this[_0x477225(0x20b)]['deactivate'](),this['_partyCommandWindow'][_0x477225(0x216)](),this[_0x477225(0x1f8)][_0x477225(0x39f)](),this[_0x477225(0x1f8)][_0x477225(0x216)](),BattleManager[_0x477225(0x245)]=null,BattleManager[_0x477225(0x390)]=![];},Scene_Battle[_0x43c6f3(0x2bb)][_0x43c6f3(0x275)]=function(){const _0x5051b0=_0x43c6f3;if(BattleManager[_0x5051b0(0x2b8)]())return;if(!SceneManager['isPreviousScene'](Scene_Party))return;Imported['VisuMZ_2_BattleSystemBTB']&&BattleManager[_0x5051b0(0x24d)]()&&BattleManager['makeActionOrders']();Imported['VisuMZ_2_BattleSystemFTB']&&BattleManager[_0x5051b0(0x207)]()&&(BattleManager[_0x5051b0(0x245)]=$gameParty[_0x5051b0(0x241)](),BattleManager['_subject']=BattleManager[_0x5051b0(0x372)](),BattleManager[_0x5051b0(0x390)]=!![],this[_0x5051b0(0x1f8)][_0x5051b0(0x21e)](BattleManager[_0x5051b0(0x372)]()),this[_0x5051b0(0x22b)]['selectActor'](BattleManager[_0x5051b0(0x372)]()));Imported[_0x5051b0(0x1e7)]&&BattleManager[_0x5051b0(0x381)]()&&(BattleManager['_currentActor']=$gameParty[_0x5051b0(0x241)](),BattleManager[_0x5051b0(0x313)]=BattleManager['actor'](),BattleManager[_0x5051b0(0x390)]=!![],this[_0x5051b0(0x1f8)][_0x5051b0(0x21e)](BattleManager[_0x5051b0(0x372)]()),this['_statusWindow'][_0x5051b0(0x320)](BattleManager[_0x5051b0(0x372)]()));if(Imported[_0x5051b0(0x25a)]&&BattleManager[_0x5051b0(0x290)]()){if(_0x5051b0(0x316)==='PDwLR'){if(this[_0x5051b0(0x308)]===_0x59838d)return;this[_0x5051b0(0x308)]=_0x5158d1;if(_0x470583){const _0x37a154=_0x4f09d2[_0x5051b0(0x35a)](_0x161ed6['faceName']());_0x37a154[_0x5051b0(0x2d4)](this[_0x5051b0(0x253)][_0x5051b0(0x1e9)](this));}else this[_0x5051b0(0x253)]();}else BattleManager[_0x5051b0(0x245)]=$gameParty[_0x5051b0(0x241)](),BattleManager[_0x5051b0(0x313)]=BattleManager['actor'](),BattleManager[_0x5051b0(0x390)]=!![],this['_actorCommandWindow'][_0x5051b0(0x21e)](BattleManager[_0x5051b0(0x372)]()),this[_0x5051b0(0x22b)][_0x5051b0(0x320)](BattleManager[_0x5051b0(0x372)]());}},Game_Party[_0x43c6f3(0x2bb)][_0x43c6f3(0x241)]=function(){let _0x3a7b43=this['battleMembers']();return _0x3a7b43[0x0];},Sprite_Actor[_0x43c6f3(0x311)]=0xc,Sprite_Actor['prototype']['startSwitchOutAnimation']=function(_0x542858){const _0x29334d=_0x43c6f3;this[_0x29334d(0x382)]=_0x542858;const _0x58c937=Sprite_Actor['_partySwitchDuration'];this[_0x29334d(0x21f)](0x12c,0x0,_0x58c937),this['startOpacity'](0x0,_0x58c937),this[_0x29334d(0x311)]=_0x58c937;},Sprite_Actor[_0x43c6f3(0x2bb)][_0x43c6f3(0x3a1)]=function(_0x1c8527){const _0x264424=_0x43c6f3;if(SceneManager['isSceneBattle']()){SceneManager[_0x264424(0x2b4)][_0x264424(0x3a0)](_0x1c8527);const _0x18bc01=Sprite_Actor['_partySwitchDuration'];this[_0x264424(0x2f1)](),this['startOpacity'](0xff,_0x18bc01);}this[_0x264424(0x382)]=null;},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3a9)]=Sprite_Actor[_0x43c6f3(0x2bb)][_0x43c6f3(0x3c5)],Sprite_Actor[_0x43c6f3(0x2bb)][_0x43c6f3(0x3c5)]=function(){const _0x1f8228=_0x43c6f3;VisuMZ[_0x1f8228(0x36a)][_0x1f8228(0x3a9)][_0x1f8228(0x3c9)](this);if(this[_0x1f8228(0x311)])this[_0x1f8228(0x20f)]();},Sprite_Actor['prototype']['updatePartySwitch']=function(){const _0x4ed4f9=_0x43c6f3;this[_0x4ed4f9(0x311)]=this[_0x4ed4f9(0x311)]||0x0,this[_0x4ed4f9(0x311)]--;if(this[_0x4ed4f9(0x311)]<=0x0){if(_0x4ed4f9(0x3f8)===_0x4ed4f9(0x1eb)){if(this['_partyMemberSwitchWindow']&&this[_0x4ed4f9(0x2ac)][_0x4ed4f9(0x34b)])return!![];if(this[_0x4ed4f9(0x3b8)])return!![];if(this['_callPartyMemberSwitch'])return!![];if(this[_0x4ed4f9(0x283)])return!![];return _0x48e547[_0x4ed4f9(0x36a)][_0x4ed4f9(0x247)][_0x4ed4f9(0x3c9)](this);}else this[_0x4ed4f9(0x3a1)](this[_0x4ed4f9(0x382)]);}},Window_PartyCommand[_0x43c6f3(0x2bb)][_0x43c6f3(0x2a7)]=function(){this['addFormationCommand']();},Window_PartyCommand[_0x43c6f3(0x2bb)]['addFormationCommand']=function(){const _0x1779d6=_0x43c6f3;if(!this[_0x1779d6(0x2e0)]())return;if(this['hasBattleSystemIncompatibilities']()){$gameTemp[_0x1779d6(0x2f2)]()&&!BattleManager[_0x1779d6(0x394)]&&(console[_0x1779d6(0x210)]('WARNING:\x20Party\x20Change\x20command\x20is\x20unavailable\x20for\x20Window_PartyCommand\x20for\x20this\x20Battle\x20System'),BattleManager[_0x1779d6(0x394)]=!![]);return;}const _0x32096a=this[_0x1779d6(0x28c)](),_0x1be46d=ImageManager['battlePartyChangeIcon'],_0x5650ce=_0x32096a===_0x1779d6(0x222)?TextManager['battlePartyChangeCmd']:'\x5cI[%1]%2'[_0x1779d6(0x343)](_0x1be46d,TextManager[_0x1779d6(0x233)]),_0x50b191=this[_0x1779d6(0x292)]();this[_0x1779d6(0x389)](_0x5650ce,_0x1779d6(0x3a2),_0x50b191);},Window_PartyCommand['prototype'][_0x43c6f3(0x2e0)]=function(){const _0x562c14=_0x43c6f3;if(Imported['VisuMZ_2_BattleSystemOTB']&&BattleManager[_0x562c14(0x342)]())return![];return VisuMZ['PartySystem'][_0x562c14(0x3f9)][_0x562c14(0x327)][_0x562c14(0x309)];},Window_PartyCommand['prototype'][_0x43c6f3(0x1e6)]=function(){const _0x5ccc01=_0x43c6f3;if(Imported[_0x5ccc01(0x350)]&&BattleManager[_0x5ccc01(0x37e)]())return!![];return![];},Window_PartyCommand['prototype']['isFormationCommandEnabled']=function(){const _0x2642ba=_0x43c6f3;if($gameParty['allMembers']()[_0x2642ba(0x29d)]<=0x1)return![];if(!$gameParty[_0x2642ba(0x3f0)]())return![];return $gameSystem[_0x2642ba(0x305)]();},VisuMZ['PartySystem']['Settings']['Window_PartyCommand_updateHelp']=Window_PartyCommand[_0x43c6f3(0x2bb)]['updateHelp'],Window_PartyCommand['prototype'][_0x43c6f3(0x380)]=function(){const _0x3edeb4=_0x43c6f3,_0x2d171a=this['currentSymbol']();switch(_0x2d171a){case _0x3edeb4(0x3a2):this[_0x3edeb4(0x3ca)][_0x3edeb4(0x30c)](TextManager[_0x3edeb4(0x2ba)]);break;default:VisuMZ['PartySystem'][_0x3edeb4(0x3f9)][_0x3edeb4(0x31a)][_0x3edeb4(0x3c9)](this);break;}},Window_ActorCommand[_0x43c6f3(0x2bb)][_0x43c6f3(0x29f)]=function(){const _0x196637=_0x43c6f3;if(!this[_0x196637(0x2e2)]())return;if(this[_0x196637(0x3e4)](_0x196637(0x3a2))>=0x0){if('FZHKl'==='fpZHL'){if(_0x6357ff['uiMenuStyle']&&_0x4fa789[_0x196637(0x32c)]!==_0x455ffe)return _0x50767e[_0x196637(0x32c)];else return _0x1f4fc0['uiMenuStyle']===![]?![]:_0x72c977[_0x196637(0x2bb)]['isRightInputMode']['call'](this);}else this[_0x196637(0x231)]();}const _0x4f0933=this[_0x196637(0x28c)](),_0x5afd03=ImageManager[_0x196637(0x1ec)],_0x513301=_0x4f0933===_0x196637(0x222)?TextManager['battlePartySwitchCmd']:_0x196637(0x23b)[_0x196637(0x343)](_0x5afd03,TextManager['battlePartyChangeCmd']),_0x3a590b=this[_0x196637(0x2ef)]();this[_0x196637(0x389)](_0x513301,_0x196637(0x3a2),_0x3a590b);},Window_ActorCommand[_0x43c6f3(0x2bb)][_0x43c6f3(0x2e2)]=function(){const _0x270568=_0x43c6f3;if(!this[_0x270568(0x308)])return![];return VisuMZ[_0x270568(0x36a)][_0x270568(0x3f9)][_0x270568(0x327)][_0x270568(0x359)];},Window_ActorCommand[_0x43c6f3(0x2bb)][_0x43c6f3(0x2ef)]=function(){const _0x20a53d=_0x43c6f3;if($gameParty['allMembers']()[_0x20a53d(0x29d)]<=0x1)return![];if(!this['_actor'])return![];if(!this[_0x20a53d(0x308)][_0x20a53d(0x3f0)]())return![];return this[_0x20a53d(0x308)][_0x20a53d(0x30f)]();},VisuMZ[_0x43c6f3(0x36a)][_0x43c6f3(0x3f9)][_0x43c6f3(0x2ae)]=Window_ActorCommand[_0x43c6f3(0x2bb)]['updateHelp'],Window_ActorCommand[_0x43c6f3(0x2bb)][_0x43c6f3(0x380)]=function(){const _0x14ffc0=_0x43c6f3,_0x543753=this[_0x14ffc0(0x257)]();if(!_0x543753)return;switch(_0x543753[_0x14ffc0(0x3c8)]()){case _0x14ffc0(0x3a2):this[_0x14ffc0(0x3ca)][_0x14ffc0(0x30c)](TextManager['battlePartySwitchCmdHelp']);break;default:VisuMZ['PartySystem'][_0x14ffc0(0x3f9)][_0x14ffc0(0x2ae)][_0x14ffc0(0x3c9)](this);break;}},Window_ActorCommand[_0x43c6f3(0x2bb)][_0x43c6f3(0x231)]=function(){const _0x46c374=_0x43c6f3;while(this[_0x46c374(0x3e4)](_0x46c374(0x3a2))>=0x0){const _0x53838d=this[_0x46c374(0x3e4)](_0x46c374(0x3a2));this[_0x46c374(0x33e)][_0x46c374(0x3c7)](_0x53838d,0x1);}});;